/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.teiid.designer.query.sql.lang.ISPParameter;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.runtime.client.Messages;

public class SPParameter
implements ISPParameter<ElementSymbol> {
    public static final int IN = ISPParameter.ParameterInfo.IN.index();
    public static final int OUT = ISPParameter.ParameterInfo.OUT.index();
    public static final int INOUT = ISPParameter.ParameterInfo.INOUT.index();
    public static final int RETURN_VALUE = ISPParameter.ParameterInfo.RETURN_VALUE.index();
    public static final int RESULT_SET = ISPParameter.ParameterInfo.RESULT_SET.index();
    private int parameterType = ISPParameter.ParameterInfo.IN.index();
    private Expression expression;
    private int index;
    private List<ElementSymbol> resultSetColumns;
    private List<Object> resultSetIDs;
    private boolean usingDefault;
    private boolean varArg;
    private ElementSymbol parameterSymbol;
    private TeiidParser teiidParser;

    public SPParameter(TeiidParser teiidParser, int index, Expression expression) {
        this.teiidParser = teiidParser;
        this.setIndex(index);
        this.setExpression(expression);
        this.parameterSymbol = (ElementSymbol)teiidParser.createASTNode(TeiidNodeFactory.ASTNodes.ELEMENT_SYMBOL);
    }

    public SPParameter(TeiidParser teiidParser, int index, int parameterType, String name) {
        this.teiidParser = teiidParser;
        this.setIndex(index);
        this.setParameterType(parameterType);
        this.setName(name);
    }

    private ElementSymbol createElementSymbol(String name) {
        ElementSymbol symbol = (ElementSymbol)this.teiidParser.createASTNode(TeiidNodeFactory.ASTNodes.ELEMENT_SYMBOL);
        symbol.setName(name);
        return symbol;
    }

    public String getName() {
        return this.parameterSymbol.getName();
    }

    public void setName(String name) {
        if (this.parameterSymbol == null) {
            this.parameterSymbol = this.createElementSymbol(name);
        } else {
            ElementSymbol es = this.createElementSymbol(name);
            es.setMetadataID(this.parameterSymbol.getMetadataID());
            es.setType(this.parameterSymbol.getType());
            this.parameterSymbol = es;
        }
    }

    public void setParameterType(ISPParameter.ParameterInfo parameterInfo) {
        this.parameterType = parameterInfo.index();
    }

    public void setParameterType(int parameterType) {
        if (parameterType < ISPParameter.ParameterInfo.IN.index() || parameterType > ISPParameter.ParameterInfo.RESULT_SET.index()) {
            throw new IllegalArgumentException(Messages.getString(Messages.ERR.ERR_015_010_0006, parameterType));
        }
        this.parameterType = parameterType;
    }

    public int getParameterType() {
        return this.parameterType;
    }

    public void setClassType(Class<?> classType) {
        this.parameterSymbol.setType(classType);
    }

    public Class<?> getClassType() {
        return this.parameterSymbol.getType();
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void addResultSetColumn(String colName, Class<?> type, Object id) {
        if (this.resultSetColumns == null) {
            this.resultSetColumns = new ArrayList<ElementSymbol>();
            this.resultSetIDs = new ArrayList<Object>();
        }
        ElementSymbol rsColumn = this.createElementSymbol(colName);
        rsColumn.setType(type);
        rsColumn.setMetadataID(id);
        this.resultSetColumns.add(rsColumn);
        this.resultSetIDs.add(id);
    }

    public List<ElementSymbol> getResultSetColumns() {
        if (this.resultSetColumns == null) {
            return Collections.emptyList();
        }
        return this.resultSetColumns;
    }

    public List<Object> getResultSetIDs() {
        if (this.resultSetIDs == null) {
            return Collections.emptyList();
        }
        return this.resultSetIDs;
    }

    public ElementSymbol getResultSetColumn(int position) {
        if (this.resultSetColumns == null) {
            throw new IllegalArgumentException(Messages.getString(Messages.ERR.ERR_015_010_0009, new Object[0]));
        }
        if (--position >= 0 && position < this.resultSetColumns.size()) {
            return this.resultSetColumns.get(position);
        }
        throw new IllegalArgumentException(Messages.getString(Messages.ERR.ERR_015_010_0010, new Integer(position + 1)));
    }

    public Object getMetadataID() {
        return this.parameterSymbol.getMetadataID();
    }

    public void setMetadataID(Object metadataID) {
        this.parameterSymbol.setMetadataID(metadataID);
    }

    public ElementSymbol getParameterSymbol() {
        return this.parameterSymbol;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SPParameter other = (SPParameter)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        return !(this.teiidParser == null ? other.teiidParser != null : !this.teiidParser.equals(other.teiidParser));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + this.index;
        result = 31 * result + (this.teiidParser == null ? 0 : this.teiidParser.hashCode());
        return result;
    }

    public String toString() {
        if (this.expression != null) {
            return this.expression.toString();
        }
        return "?";
    }

    public boolean isUsingDefault() {
        return this.usingDefault;
    }

    public void setUsingDefault(boolean usingDefault) {
        this.usingDefault = usingDefault;
    }

    public void setVarArg(boolean varArg) {
        this.varArg = varArg;
    }

    public boolean isVarArg() {
        return this.varArg;
    }

    public SPParameter clone() {
        SPParameter clone = new SPParameter(this.teiidParser, this.getIndex(), this.getExpression());
        clone.setParameterType(this.getParameterType());
        if (this.parameterSymbol != null) {
            clone.parameterSymbol = this.parameterSymbol.clone();
        }
        if (this.getExpression() != null) {
            clone.setExpression(this.getExpression().clone());
        }
        if (this.resultSetColumns != null) {
            Iterator<ElementSymbol> iter = this.resultSetColumns.iterator();
            Iterator<Object> idIter = this.resultSetIDs.iterator();
            while (iter.hasNext()) {
                ElementSymbol column = iter.next();
                clone.addResultSetColumn(column.getName(), column.getType(), idIter.next());
            }
        }
        clone.setUsingDefault(this.isUsingDefault());
        clone.setVarArg(this.isVarArg());
        return clone;
    }
}

