/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.query.sql.lang.ISetQuery;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.util.SymbolMap;

public class SetQuery
extends QueryCommand
implements ISetQuery<QueryCommand, OrderBy, Query, Expression, LanguageVisitor> {
    private boolean all = true;
    private ISetQuery.Operation operation;
    private QueryCommand leftQuery;
    private QueryCommand rightQuery;
    private List<Class<?>> projectedTypes = null;
    private IQueryMetadataInterface metadata = null;

    public SetQuery(TeiidParser p, int id) {
        super(p, id);
    }

    public int getType() {
        return 1;
    }

    public void setOperation(ISetQuery.Operation operation) {
        this.operation = operation;
    }

    public ISetQuery.Operation getOperation() {
        return this.operation;
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public QueryCommand getLeftQuery() {
        return this.leftQuery;
    }

    public void setLeftQuery(QueryCommand leftQuery) {
        this.leftQuery = leftQuery;
    }

    public QueryCommand getRightQuery() {
        return this.rightQuery;
    }

    public void setRightQuery(QueryCommand rightQuery) {
        this.rightQuery = rightQuery;
    }

    public List<QueryCommand> getQueryCommands() {
        return Collections.unmodifiableList(Arrays.asList(this.leftQuery, this.rightQuery));
    }

    public Query getProjectedQuery() {
        if (this.leftQuery instanceof SetQuery) {
            return ((SetQuery)this.leftQuery).getProjectedQuery();
        }
        return (Query)this.leftQuery;
    }

    public List<Expression> getProjectedSymbols() {
        Query query = this.getProjectedQuery();
        List<Expression> projectedSymbols = query.getProjectedSymbols();
        if (this.projectedTypes != null) {
            return SetQuery.getTypedProjectedSymbols(projectedSymbols, this.projectedTypes, this.metadata);
        }
        return projectedSymbols;
    }

    public void setProjectedTypes(List<Class<?>> projectedTypes, IQueryMetadataInterface metadata) {
        this.projectedTypes = projectedTypes;
        this.metadata = metadata;
    }

    public List<Class<?>> getProjectedTypes() {
        return this.projectedTypes;
    }

    public static List<Expression> getTypedProjectedSymbols(List<? extends Expression> acutal, List<Class<?>> projectedTypes, IQueryMetadataInterface metadata) {
        ArrayList<Expression> newProject = new ArrayList<Expression>();
        int i = 0;
        while (i < acutal.size()) {
            Expression originalSymbol;
            Expression symbol = originalSymbol = acutal.get(i);
            Class<?> type = projectedTypes.get(i);
            if (symbol.getType() != type) {
                symbol = SymbolMap.getExpression(originalSymbol);
                try {
                    symbol = ResolverUtil.convertExpression(symbol, DataTypeManagerService.getInstance(symbol.getTeiidVersion()).getDataTypeName(type), metadata);
                }
                catch (Exception err) {
                    throw new RuntimeException(err);
                }
                if (originalSymbol instanceof Symbol) {
                    TeiidParser teiidParser = originalSymbol.getTeiidParser();
                    AliasSymbol aliasSymbol = (AliasSymbol)teiidParser.createASTNode(TeiidNodeFactory.ASTNodes.ALIAS_SYMBOL);
                    aliasSymbol.setName(Symbol.getShortName(originalSymbol));
                    aliasSymbol.setSymbol(symbol);
                    symbol = aliasSymbol;
                }
            }
            newProject.add(symbol);
            ++i;
        }
        return newProject;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.all ? 1231 : 1237);
        result = 31 * result + (this.leftQuery == null ? 0 : this.leftQuery.hashCode());
        result = 31 * result + (this.operation == null ? 0 : this.operation.hashCode());
        result = 31 * result + (this.rightQuery == null ? 0 : this.rightQuery.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetQuery other = (SetQuery)obj;
        if (this.all != other.all) {
            return false;
        }
        if (this.leftQuery == null ? other.leftQuery != null : !this.leftQuery.equals(other.leftQuery)) {
            return false;
        }
        if (this.operation != other.operation) {
            return false;
        }
        return !(this.rightQuery == null ? other.rightQuery != null : !this.rightQuery.equals(other.rightQuery));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SetQuery clone() {
        SetQuery clone = new SetQuery(this.parser, this.id);
        this.copyMetadataState(clone);
        if (this.getOperation() != null) {
            clone.setOperation(this.getOperation());
        }
        clone.setAll(this.isAll());
        if (this.getLeftQuery() != null) {
            clone.setLeftQuery(this.getLeftQuery().clone());
        }
        if (this.getRightQuery() != null) {
            clone.setRightQuery(this.getRightQuery().clone());
        }
        if (this.getOrderBy() != null) {
            clone.setOrderBy(this.getOrderBy().clone());
        }
        if (this.getLimit() != null) {
            clone.setLimit(this.getLimit().clone());
        }
        if (this.getWith() != null) {
            clone.setWith(this.cloneList(this.getWith()));
        }
        if (this.getSourceHint() != null) {
            clone.setSourceHint(this.getSourceHint());
        }
        if (this.getOption() != null) {
            clone.setOption(this.getOption().clone());
        }
        if (this.getProjectedTypes() != null) {
            clone.setProjectedTypes(new ArrayList(this.getProjectedTypes()), this.metadata);
        }
        return clone;
    }
}

