/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.Comment;
import org.teiid.query.sql.lang.LanguageObject;
import org.teiid.query.sql.lang.Node;
import org.teiid.query.sql.visitor.SQLStringVisitor;
import org.teiid.runtime.client.admin.StringConstants;

public class SimpleNode
implements Node,
LanguageObject,
StringConstants {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Object value;
    protected TeiidParser parser;

    public SimpleNode(TeiidParser p, int i) {
        this.id = i;
        this.parser = p;
    }

    @Override
    public TeiidParser getTeiidParser() {
        return this.parser;
    }

    public ITeiidServerVersion getTeiidVersion() {
        return this.parser.getVersion();
    }

    protected boolean isTeiidVersionOrGreater(TeiidServerVersion.Version teiidVersion) {
        ITeiidServerVersion minVersion = this.getTeiidVersion().getMinimumVersion();
        return minVersion.equals(teiidVersion.get()) || minVersion.isGreaterThan(teiidVersion.get());
    }

    protected boolean isLessThanTeiidVersion(TeiidServerVersion.Version teiidVersion) {
        ITeiidServerVersion maxVersion = this.getTeiidVersion().getMaximumVersion();
        return maxVersion.isLessThan(teiidVersion.get());
    }

    protected boolean isTeiid8OrGreater() {
        return this.isTeiidVersionOrGreater(TeiidServerVersion.Version.TEIID_8_0);
    }

    protected boolean isTeiid87OrGreater() {
        return this.isTeiidVersionOrGreater(TeiidServerVersion.Version.TEIID_8_7);
    }

    @Override
    public Set<Comment> getComments() {
        return this.parser.getComments();
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public void jjtSetValue(Object value) {
        this.value = value;
    }

    public Object jjtGetValue() {
        return this.value;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public void dump() {
        System.out.println(this.toString());
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n != null) {
                    n.dump();
                }
                ++i;
            }
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleNode other = (SimpleNode)obj;
        return this.id == other.id;
    }

    @Override
    public SimpleNode clone() {
        SimpleNode clone = new SimpleNode(this.parser, this.id);
        return clone;
    }

    protected <T extends LanguageObject> Collection<T> cloneCollection(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        HashSet<LanguageObject> cloned = new HashSet<LanguageObject>();
        for (LanguageObject item : collection) {
            cloned.add(item.clone());
        }
        return cloned;
    }

    protected <T extends LanguageObject> List<T> cloneList(List<T> list) {
        if (list == null) {
            return null;
        }
        ArrayList<LanguageObject> cloned = new ArrayList<LanguageObject>();
        for (LanguageObject item : list) {
            cloned.add(item.clone());
        }
        return cloned;
    }
}

