/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.teiid.designer.query.sql.lang.ITableFunctionReference;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.ProjectedColumn;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;

public abstract class TableFunctionReference
extends FromClause
implements ITableFunctionReference<LanguageVisitor> {
    private GroupSymbol symbol;
    private SymbolMap correlatedReferences;

    public TableFunctionReference(TeiidParser p, int id) {
        super(p, id);
    }

    public SymbolMap getCorrelatedReferences() {
        return this.correlatedReferences;
    }

    public void setCorrelatedReferences(SymbolMap correlatedReferences) {
        this.correlatedReferences = correlatedReferences;
    }

    public void copy(TableFunctionReference copy) {
        copy.symbol = this.symbol.clone();
        if (this.correlatedReferences != null) {
            copy.correlatedReferences = this.correlatedReferences.clone();
        }
    }

    @Override
    public void collectGroups(Collection<GroupSymbol> groups) {
        groups.add(this.getGroupSymbol());
    }

    public String getName() {
        return this.symbol.getName();
    }

    public String getOutputName() {
        return this.symbol.getOutputName();
    }

    public GroupSymbol getGroupSymbol() {
        return this.symbol;
    }

    public void setName(String name) {
        this.symbol = (GroupSymbol)this.parser.createASTNode(TeiidNodeFactory.ASTNodes.GROUP_SYMBOL);
        this.symbol.setName(name);
    }

    public abstract List<? extends ProjectedColumn> getColumns();

    public List<ElementSymbol> getProjectedSymbols() {
        ArrayList<ElementSymbol> symbols = new ArrayList<ElementSymbol>(this.getColumns().size());
        for (ProjectedColumn projectedColumn : this.getColumns()) {
            symbols.add(projectedColumn.getSymbol());
        }
        return symbols;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.correlatedReferences == null ? 0 : this.correlatedReferences.hashCode());
        result = 31 * result + (this.symbol == null ? 0 : this.symbol.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableFunctionReference other = (TableFunctionReference)obj;
        if (this.correlatedReferences == null ? other.correlatedReferences != null : !this.correlatedReferences.equals(other.correlatedReferences)) {
            return false;
        }
        return !(this.symbol == null ? other.symbol != null : !this.symbol.equals(other.symbol));
    }
}

