/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.List;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.query.sql.lang.ITextTable;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.TableFunctionReference;
import org.teiid.query.sql.lang.TextColumn;
import org.teiid.query.sql.symbol.Expression;

public class TextTable
extends TableFunctionReference
implements ITextTable<LanguageVisitor> {
    private Expression file;
    private List<TextColumn> columns = new ArrayList<TextColumn>();
    private Character delimiter;
    @Since(value=TeiidServerVersion.Version.TEIID_8_10)
    private Character rowDelimiter;
    private Character quote;
    private boolean escape;
    private Integer header;
    private Integer skip;
    private boolean usingRowDelimiter = true;
    private String selector;
    private boolean fixedWidth;

    public TextTable(TeiidParser p, int id) {
        super(p, id);
    }

    public Expression getFile() {
        return this.file;
    }

    public void setFile(Expression file) {
        this.file = file;
    }

    public List<TextColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<TextColumn> columns) {
        this.columns = columns;
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_10)
    public Character getRowDelimiter() {
        if (this.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_10)) {
            return null;
        }
        return this.rowDelimiter;
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_10)
    public void setRowDelimiter(Character rowDelimiter) {
        if (this.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_10)) {
            return;
        }
        this.rowDelimiter = rowDelimiter;
    }

    public Character getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(Character delimiter) {
        this.delimiter = delimiter;
    }

    public Character getQuote() {
        return this.quote;
    }

    public void setQuote(Character quote) {
        this.quote = quote;
    }

    public boolean isEscape() {
        return this.escape;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public Integer getHeader() {
        return this.header;
    }

    public void setHeader(Integer header) {
        this.header = header;
    }

    public Integer getSkip() {
        return this.skip;
    }

    public void setSkip(Integer skip) {
        this.skip = skip;
    }

    public boolean isUsingRowDelimiter() {
        return this.usingRowDelimiter;
    }

    public void setUsingRowDelimiter(boolean usingRowDelimiter) {
        this.usingRowDelimiter = usingRowDelimiter;
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_10)
    public void setNoTrim() {
        if (this.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_10)) {
            return;
        }
        for (TextColumn col : this.columns) {
            col.setNoTrim(true);
        }
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_10)
    public boolean isNoTrim() {
        if (this.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_10)) {
            return false;
        }
        for (TextColumn col : this.columns) {
            if (col.isNoTrim()) continue;
            return false;
        }
        return true;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public boolean isFixedWidth() {
        return this.fixedWidth;
    }

    public void setFixedWidth(boolean fixedWidth) {
        this.fixedWidth = fixedWidth;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.columns == null ? 0 : this.columns.hashCode());
        result = 31 * result + (this.delimiter == null ? 0 : this.delimiter.hashCode());
        result = 31 * result + (this.escape ? 1231 : 1237);
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.fixedWidth ? 1231 : 1237);
        result = 31 * result + (this.header == null ? 0 : this.header.hashCode());
        result = 31 * result + (this.quote == null ? 0 : this.quote.hashCode());
        result = 31 * result + (this.selector == null ? 0 : this.selector.hashCode());
        result = 31 * result + (this.skip == null ? 0 : this.skip.hashCode());
        result = 31 * result + (this.usingRowDelimiter ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextTable other = (TextTable)obj;
        if (this.columns == null ? other.columns != null : !this.columns.equals(other.columns)) {
            return false;
        }
        if (this.delimiter == null ? other.delimiter != null : !this.delimiter.equals(other.delimiter)) {
            return false;
        }
        if (this.escape != other.escape) {
            return false;
        }
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        if (this.fixedWidth != other.fixedWidth) {
            return false;
        }
        if (this.header == null ? other.header != null : !this.header.equals(other.header)) {
            return false;
        }
        if (this.quote == null ? other.quote != null : !this.quote.equals(other.quote)) {
            return false;
        }
        if (this.selector == null ? other.selector != null : !this.selector.equals(other.selector)) {
            return false;
        }
        if (this.skip == null ? other.skip != null : !this.skip.equals(other.skip)) {
            return false;
        }
        if (this.usingRowDelimiter != other.usingRowDelimiter) {
            return false;
        }
        return !this.getTeiidVersion().isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_10) || !(this.delimiter == null ? other.delimiter != null : !this.delimiter.equals(other.delimiter));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public TextTable clone() {
        TextTable clone = new TextTable(this.parser, this.id);
        if (this.getColumns() != null) {
            clone.setColumns(this.cloneList(this.getColumns()));
        }
        if (this.getSelector() != null) {
            clone.setSelector(this.getSelector());
        }
        if (this.getDelimiter() != null) {
            clone.setDelimiter(this.getDelimiter());
        }
        if (this.getQuote() != null) {
            clone.setQuote(this.getQuote());
        }
        if (this.getFile() != null) {
            clone.setFile(this.getFile().clone());
        }
        clone.setEscape(this.isEscape());
        if (this.getHeader() != null) {
            clone.setHeader(this.getHeader());
        }
        if (this.getSkip() != null) {
            clone.setSkip(this.getSkip());
        }
        clone.setUsingRowDelimiter(this.isUsingRowDelimiter());
        clone.setRowDelimiter(this.getDelimiter());
        clone.setFixedWidth(this.isFixedWidth());
        if (this.getName() != null) {
            clone.setName(this.getName());
        }
        clone.setOptional(this.isOptional());
        clone.setMakeInd(this.isMakeInd());
        clone.setMakeInd(this.getMakeInd());
        clone.setNoUnnest(this.isNoUnnest());
        clone.setMakeDep(this.isMakeDep());
        clone.setMakeNotDep(this.isMakeNotDep());
        clone.setPreserve(this.isPreserve());
        return clone;
    }
}

