/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.List;
import org.teiid.designer.query.sql.lang.IUpdate;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.lang.TargetedCommand;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;

public class Update
extends ProcedureContainer
implements TargetedCommand,
IUpdate<Expression, LanguageVisitor> {
    private SetClauseList changeList;
    private GroupSymbol group;
    private Criteria criteria;

    public Update(TeiidParser p, int id) {
        super(p, id);
    }

    public int getType() {
        return 3;
    }

    public SetClauseList getChangeList() {
        return this.changeList;
    }

    public void addChange(ElementSymbol id, Expression value) {
        if (this.changeList == null) {
            this.changeList = (SetClauseList)this.parser.createASTNode(TeiidNodeFactory.ASTNodes.SET_CLAUSE_LIST);
        }
        SetClause setClause = (SetClause)this.parser.createASTNode(TeiidNodeFactory.ASTNodes.SET_CLAUSE);
        setClause.setSymbol(id);
        setClause.setValue(value);
        this.changeList.addClause(setClause);
    }

    public void setChangeList(SetClauseList changeList) {
        this.changeList = changeList;
    }

    @Override
    public GroupSymbol getGroup() {
        return this.group;
    }

    public void setGroup(GroupSymbol group) {
        this.group = group;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }

    public List<Expression> getProjectedSymbols() {
        return this.getUpdateCommandSymbol();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.changeList == null ? 0 : this.changeList.hashCode());
        result = 31 * result + (this.criteria == null ? 0 : this.criteria.hashCode());
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Update other = (Update)obj;
        if (this.changeList == null ? other.changeList != null : !this.changeList.equals(other.changeList)) {
            return false;
        }
        if (this.criteria == null ? other.criteria != null : !this.criteria.equals(other.criteria)) {
            return false;
        }
        return !(this.group == null ? other.group != null : !this.group.equals(other.group));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Update clone() {
        Update clone = new Update(this.parser, this.id);
        if (this.getCriteria() != null) {
            clone.setCriteria(this.getCriteria().clone());
        }
        if (this.getGroup() != null) {
            clone.setGroup(this.getGroup().clone());
        }
        if (this.getChangeList() != null) {
            clone.setChangeList(this.getChangeList().clone());
        }
        if (this.getSourceHint() != null) {
            clone.setSourceHint(this.getSourceHint());
        }
        if (this.getOption() != null) {
            clone.setOption(this.getOption().clone());
        }
        this.copyMetadataState(clone);
        return clone;
    }
}

