/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.proc;

import java.util.ArrayList;
import java.util.List;
import org.teiid.designer.query.sql.proc.IBlock;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Labeled;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.symbol.ElementSymbol;

public class Block
extends Statement
implements Labeled,
IBlock<Statement, LanguageVisitor> {
    private List<Statement> statements = new ArrayList<Statement>();
    private boolean atomic;
    private String label;
    private String exceptionGroup;
    private List<Statement> exceptionStatements;

    public Block(TeiidParser p, int id) {
        super(p, id);
    }

    @Override
    public Statement.StatementType getType() {
        return Statement.StatementType.TYPE_COMPOUND;
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public void addStatement(Statement statement) {
        this.addStatement(statement, false);
    }

    public void addStatement(Statement statement, boolean exception) {
        AssignmentStatement stmt;
        Command cmd;
        if (statement instanceof AssignmentStatement && (cmd = (stmt = (AssignmentStatement)statement).getCommand()) != null) {
            CommandStatement cs = (CommandStatement)this.parser.createASTNode(TeiidNodeFactory.ASTNodes.COMMAND_STATEMENT);
            cs.setCommand(cmd);
            this.internalAddStatement(cs, exception);
            stmt.setCommand(null);
            stmt.setExpression(null);
            ElementSymbol variable = stmt.getVariable();
            if (variable != null && variable.getShortName().equalsIgnoreCase("ROWCOUNT") && variable.getGroupSymbol() != null && variable.getGroupSymbol().getName().equalsIgnoreCase("VARIABLES")) {
                return;
            }
            String fullName = "VARIABLES.ROWCOUNT";
            ElementSymbol es = (ElementSymbol)this.parser.createASTNode(TeiidNodeFactory.ASTNodes.ELEMENT_SYMBOL);
            es.setName(fullName);
            stmt.setExpression(es);
        }
        this.internalAddStatement(statement, exception);
    }

    private void internalAddStatement(Statement statement, boolean exception) {
        if (exception) {
            if (this.exceptionStatements == null) {
                this.exceptionStatements = new ArrayList<Statement>();
            }
            this.exceptionStatements.add(statement);
        } else {
            this.statements.add(statement);
        }
    }

    public void setStatements(List<Statement> statements) {
        this.statements = statements;
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    public void setAtomic(boolean atomic) {
        this.atomic = atomic;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    public String getExceptionGroup() {
        return this.exceptionGroup;
    }

    public void setExceptionGroup(String exceptionGroup) {
        this.exceptionGroup = exceptionGroup;
    }

    public List<Statement> getExceptionStatements() {
        return this.exceptionStatements;
    }

    public void setExceptionStatements(List<Statement> exceptionStatements) {
        this.exceptionStatements = exceptionStatements;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.atomic ? 1231 : 1237);
        result = 31 * result + (this.exceptionGroup == null ? 0 : this.exceptionGroup.hashCode());
        result = 31 * result + (this.exceptionStatements == null ? 0 : this.exceptionStatements.hashCode());
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + (this.statements == null ? 0 : this.statements.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Block other = (Block)obj;
        if (this.atomic != other.atomic) {
            return false;
        }
        if (this.exceptionGroup == null ? other.exceptionGroup != null : !this.exceptionGroup.equals(other.exceptionGroup)) {
            return false;
        }
        if (this.exceptionStatements == null ? other.exceptionStatements != null : !this.exceptionStatements.equals(other.exceptionStatements)) {
            return false;
        }
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        return !(this.statements == null ? other.statements != null : !this.statements.equals(other.statements));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Block clone() {
        Block clone = new Block(this.parser, this.id);
        clone.setAtomic(this.isAtomic());
        if (this.getLabel() != null) {
            clone.setLabel(this.getLabel());
        }
        if (this.getExceptionGroup() != null) {
            clone.setExceptionGroup(this.getExceptionGroup());
        }
        if (this.getExceptionStatements() != null) {
            clone.setExceptionStatements(this.cloneList(this.getExceptionStatements()));
        }
        if (this.getStatements() != null) {
            clone.setStatements(this.cloneList(this.getStatements()));
        }
        return clone;
    }
}

