/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.proc;

import java.util.Collections;
import java.util.List;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.query.sql.proc.ICreateProcedureCommand;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;

@Since(value=TeiidServerVersion.Version.TEIID_8_0)
public class CreateProcedureCommand
extends Command
implements ICreateProcedureCommand<Block, GroupSymbol, Expression, LanguageVisitor> {
    protected Block block;
    private List<? extends Expression> projectedSymbols;
    private List<? extends Expression> resultSetColumns;
    private GroupSymbol virtualGroup;
    private ElementSymbol returnVariable;
    private int updateType = 0;

    public CreateProcedureCommand(TeiidParser p, int id) {
        super(p, id);
    }

    public int getType() {
        return 7;
    }

    public Block getBlock() {
        return this.block;
    }

    public void setBlock(Block block) {
        this.block = block;
    }

    @Override
    @Since(value=TeiidServerVersion.Version.TEIID_8_5)
    public boolean returnsResultSet() {
        if (this.isTeiidVersionOrGreater(TeiidServerVersion.Version.TEIID_8_5)) {
            return this.resultSetColumns != null && !this.resultSetColumns.isEmpty();
        }
        return super.returnsResultSet();
    }

    @Override
    public List<? extends Expression> getResultSetColumns() {
        return this.resultSetColumns;
    }

    public void setResultSetColumns(List<? extends Expression> resultSetColumns) {
        this.resultSetColumns = resultSetColumns;
    }

    public List<Expression> getProjectedSymbols() {
        if (this.projectedSymbols != null) {
            return this.projectedSymbols;
        }
        return Collections.EMPTY_LIST;
    }

    public void setProjectedSymbols(List<? extends Expression> projSymbols) {
        this.projectedSymbols = projSymbols;
    }

    public GroupSymbol getVirtualGroup() {
        return this.virtualGroup;
    }

    public void setVirtualGroup(GroupSymbol virtualGroup) {
        this.virtualGroup = virtualGroup;
    }

    public ElementSymbol getReturnVariable() {
        return this.returnVariable;
    }

    public void setReturnVariable(ElementSymbol symbol) {
        this.returnVariable = symbol;
    }

    public int getUpdateType() {
        return this.updateType;
    }

    public void setUpdateType(int type) {
        this.resultSetColumns = this.isTeiidVersionOrGreater(TeiidServerVersion.Version.TEIID_8_5) ? this.getUpdateCommandSymbol() : Collections.emptyList();
        this.updateType = type;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.block == null ? 0 : this.block.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreateProcedureCommand other = (CreateProcedureCommand)obj;
        return !(this.block == null ? other.block != null : !this.block.equals(other.block));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public CreateProcedureCommand clone() {
        CreateProcedureCommand clone = new CreateProcedureCommand(this.parser, this.id);
        if (this.getBlock() != null) {
            clone.setBlock(this.getBlock().clone());
        }
        if (this.getSourceHint() != null) {
            clone.setSourceHint(this.getSourceHint());
        }
        if (this.getOption() != null) {
            clone.setOption(this.getOption().clone());
        }
        if (this.projectedSymbols != null) {
            clone.projectedSymbols = this.cloneList(this.getProjectedSymbols());
        }
        if (this.resultSetColumns != null) {
            clone.resultSetColumns = this.cloneList(this.resultSetColumns);
        }
        if (this.virtualGroup != null) {
            clone.virtualGroup = this.virtualGroup.clone();
        }
        if (this.returnVariable != null) {
            clone.returnVariable = this.returnVariable;
        }
        this.copyMetadataState(clone);
        return clone;
    }
}

