/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import java.util.List;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.util.ArgCheck;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.SimpleNode;
import org.teiid.query.sql.symbol.Expression;

public class Array
extends SimpleNode
implements Expression {
    private Class<?> type;
    private List<Expression> expressions;
    private boolean implicit;

    public Array(TeiidParser p, int id) {
        super(p, id);
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        if (type != null) {
            ArgCheck.isTrue(type.isArray(), "type not array");
        }
        this.type = type;
    }

    public Class<?> getComponentType() {
        if (this.type != null) {
            return this.type.getComponentType();
        }
        return null;
    }

    public void setComponentType(Class<?> baseType) {
        if (baseType != null) {
            DataTypeManagerService.DefaultDataTypes dataType = this.getTeiidParser().getDataTypeService().getDataType(baseType);
            this.type = dataType.getTypeArrayClass();
        } else {
            this.type = null;
        }
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<Expression> expressions) {
        this.expressions = expressions;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.expressions == null ? 0 : this.expressions.hashCode());
        result = 31 * result + (this.implicit ? 1231 : 1237);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Array other = (Array)obj;
        if (this.expressions == null ? other.expressions != null : !this.expressions.equals(other.expressions)) {
            return false;
        }
        if (this.implicit != other.implicit) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Array clone() {
        Array clone = new Array(this.parser, this.id);
        if (this.getExpressions() != null) {
            clone.setExpressions(this.cloneList(this.getExpressions()));
        }
        if (this.getComponentType() != null) {
            clone.setComponentType(this.getComponentType());
        }
        clone.implicit = this.implicit;
        return clone;
    }
}

