/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import java.math.BigDecimal;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.designer.query.sql.symbol.IConstant;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.query.function.FunctionMethods;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.SimpleNode;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.runtime.client.Messages;

public class Constant
extends SimpleNode
implements Expression,
IConstant<LanguageVisitor> {
    private Class<?> type = DataTypeManagerService.DefaultDataTypes.NULL.getTypeClass();
    private boolean multiValued;
    private static Map<ITeiidServerVersion, Constant> nullCache = new HashMap<ITeiidServerVersion, Constant>();
    public static final String COLLATION_LOCALE = System.getProperties().getProperty("org.teiid.collationLocale");
    public static final boolean PAD_SPACE = PropertiesUtils.getBooleanProperty(System.getProperties(), "org.teiid.padSpace", false);
    public static final Comparator<Object> COMPARATOR = Constant.getComparator(COLLATION_LOCALE, PAD_SPACE);

    public static Constant getNullConstant(TeiidParser teiidParser) {
        Constant constant = nullCache.get(teiidParser.getVersion());
        if (constant == null) {
            constant = (Constant)teiidParser.createASTNode(TeiidNodeFactory.ASTNodes.CONSTANT);
            nullCache.put(teiidParser.getVersion(), constant);
        }
        return constant;
    }

    static Comparator<Object> getComparator(String localeString, final boolean padSpace) {
        if (localeString == null) {
            return Constant.getComparator(padSpace);
        }
        String[] parts = localeString.split("_");
        Locale locale = null;
        if (parts.length == 1) {
            locale = new Locale(parts[0]);
        } else if (parts.length == 2) {
            locale = new Locale(parts[0], parts[1]);
        } else if (parts.length == 3) {
            locale = new Locale(parts[0], parts[1], parts[2]);
        } else {
            return Constant.getComparator(padSpace);
        }
        final Collator c = Collator.getInstance(locale);
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Class<?> clazz = o1.getClass();
                if (clazz == String.class) {
                    String s1 = (String)o1;
                    String s2 = (String)o2;
                    if (padSpace) {
                        s1 = FunctionMethods.rightTrim(s1, ' ', false);
                        s2 = FunctionMethods.rightTrim(s2, ' ', false);
                    }
                    return c.compare(s1, s2);
                }
                return ((Comparable)o1).compareTo(o2);
            }
        };
    }

    static Comparator<Object> getComparator(boolean padSpace) {
        if (!padSpace) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ((Comparable)o1).compareTo(o2);
                }
            };
        }
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Class<?> clazz = o1.getClass();
                if (clazz == String.class) {
                    CharSequence s1 = (CharSequence)o1;
                    CharSequence s2 = (CharSequence)o2;
                    return Constant.comparePadded(s1, s2);
                }
                if (clazz == ClobType.class) {
                    CharSequence s1 = ((ClobType)o1).getCharSequence();
                    CharSequence s2 = ((ClobType)o2).getCharSequence();
                    return Constant.comparePadded(s1, s2);
                }
                return ((Comparable)o1).compareTo(o2);
            }
        };
    }

    public Constant(TeiidParser p, int id) {
        super(p, id);
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException(Messages.getString(Messages.ERR.ERR_015_010_0014, new Object[0]));
        }
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.jjtSetValue(value);
        if (this.value == null) {
            this.type = ((Object)((Object)DataTypeManagerService.DefaultDataTypes.NULL)).getClass();
        } else {
            this.type = this.value.getClass();
            Class<?> originalType = this.type;
            while (this.type.isArray() && !this.type.getComponentType().isPrimitive()) {
                this.type = this.type.getComponentType();
            }
            DataTypeManagerService.DefaultDataTypes dataType = this.getTeiidParser().getDataTypeService().getDataType(this.type);
            this.type = dataType != null ? originalType : (originalType.isArray() && !originalType.getComponentType().isPrimitive() ? DataTypeManagerService.DefaultDataTypes.OBJECT.getTypeArrayClass() : ((Object)((Object)DataTypeManagerService.DefaultDataTypes.OBJECT)).getClass());
        }
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    static final int comparePadded(CharSequence s1, CharSequence s2) {
        int len1 = s1.length();
        int len2 = s2.length();
        int n = Math.min(len1, len2);
        int i = 0;
        int result = 0;
        while (i < n) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 != (c2 = s2.charAt(i))) {
                return c1 - c2;
            }
            ++i;
        }
        result = len1 - len2;
        int j = i;
        while (j < len1) {
            if (s1.charAt(j) != ' ') {
                return result;
            }
            ++j;
        }
        j = i;
        while (j < len2) {
            if (s2.charAt(j) != ' ') {
                return result;
            }
            ++j;
        }
        return 0;
    }

    public void setMultiValued(List<?> value) {
        this.multiValued = true;
        this.value = value;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (this.value != null && !this.isMultiValued()) {
            if (this.value instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)this.value;
                int xsign = bd.signum();
                if (xsign == 0) {
                    return 0;
                }
                bd = bd.stripTrailingZeros();
                return 31 * result + bd.hashCode();
            }
            result = 31 * result + this.value.hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Constant other = (Constant)obj;
        if (this.value == null && other.value == null) {
            return true;
        }
        if (this.value instanceof BigDecimal) {
            if (this.value == other.value) {
                return true;
            }
            if (!(other.value instanceof BigDecimal)) {
                return false;
            }
            return ((BigDecimal)this.value).compareTo((BigDecimal)other.value) == 0;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return this.multiValued == other.multiValued && other.getValue().equals(this.getValue());
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Constant clone() {
        Constant clone = new Constant(this.parser, this.id);
        if (this.getType() != null) {
            clone.setType(this.getType());
        }
        clone.multiValued = this.multiValued;
        if (this.getValue() != null) {
            clone.setValue(this.getValue());
        }
        return clone;
    }
}

