/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import java.util.Arrays;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.query.sql.symbol.IFunction;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.SimpleNode;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;

public class Function
extends SimpleNode
implements Expression,
IFunction<FunctionDescriptor, LanguageVisitor> {
    private Class<?> type;
    private String name;
    private Expression[] args;
    private boolean implicit;
    private FunctionDescriptor descriptor;
    @Since(value=TeiidServerVersion.Version.TEIID_8_5)
    private boolean eval = true;

    public Function(TeiidParser p, int id) {
        super(p, id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Expression[] getArgs() {
        return this.args;
    }

    public Expression getArg(int index) {
        return this.args[index];
    }

    public void setArgs(Expression[] args) {
        if (args == null) {
            args = new Expression[]{};
        }
        this.args = args;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void makeImplicit() {
        this.implicit = true;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public FunctionDescriptor getFunctionDescriptor() {
        return this.descriptor;
    }

    public void setFunctionDescriptor(FunctionDescriptor fd) {
        this.descriptor = fd;
    }

    public void insertConversion(int index, FunctionDescriptor functionDescriptor) {
        Class<?> t = functionDescriptor.getReturnType();
        String typeName = this.getTeiidParser().getDataTypeService().getDataTypeName(t);
        Constant constant = (Constant)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.CONSTANT);
        constant.setValue(typeName);
        Expression[] newArg = new Expression[]{this.args[index], constant};
        Function func = (Function)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.FUNCTION);
        func.setName(functionDescriptor.getName());
        func.setArgs(newArg);
        this.args[index] = func;
        func.setFunctionDescriptor(functionDescriptor);
        func.setType(t);
        func.makeImplicit();
    }

    public boolean isAggregate() {
        return this.getFunctionDescriptor().getMethod().getAggregateAttributes() != null;
    }

    public boolean isEval() {
        if (this.isTeiidVersionOrGreater(TeiidServerVersion.Version.TEIID_8_5)) {
            return this.eval;
        }
        return false;
    }

    public void setEval(boolean eval) {
        if (this.isTeiidVersionOrGreater(TeiidServerVersion.Version.TEIID_8_5)) {
            this.eval = eval;
        }
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.toUpperCase().hashCode());
        if (this.args != null && this.args.length > 0 && this.args[0] != null) {
            result = 31 * result + Arrays.hashCode(this.args);
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Function other = (Function)obj;
        if (this.descriptor != null && other.descriptor != null && !this.descriptor.getMethod().equals(other.descriptor.getMethod())) {
            return false;
        }
        if (this.getName() == null ? other.getName() != null : !this.getName().equalsIgnoreCase(other.getName())) {
            return false;
        }
        if (this.implicit != other.implicit) {
            return false;
        }
        return Arrays.equals(this.args, other.args);
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Function clone() {
        Function clone = new Function(this.parser, this.id);
        if (this.getArgs() != null) {
            Expression[] cloned = new Expression[this.getArgs().length];
            int i = 0;
            while (i < this.getArgs().length) {
                cloned[i] = this.getArgs()[i].clone();
                ++i;
            }
            clone.setArgs(cloned);
        }
        if (this.getType() != null) {
            clone.setType(this.getType());
        }
        if (this.getName() != null) {
            clone.setName(this.getName());
        }
        clone.eval = this.eval;
        return clone;
    }
}

