/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import org.teiid.designer.annotation.Removed;
import org.teiid.designer.query.sql.symbol.IGroupSymbol;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.runtime.client.Messages;

public class GroupSymbol
extends Symbol
implements IGroupSymbol<LanguageVisitor> {
    public static final String TEMP_GROUP_PREFIX = "#";
    private String definition;
    private String outputDefinition;
    private Object metadataID;
    private boolean isProcedure;
    private boolean isTempTable;
    private String schema;

    public GroupSymbol(TeiidParser p, int id) {
        super(p, id);
    }

    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getName() {
        if (this.schema != null) {
            return String.valueOf(this.schema) + "." + this.getShortName();
        }
        return super.getName();
    }

    @Override
    public void setName(String name) {
        int index = name.indexOf(46);
        if (index > 0) {
            this.schema = new String(name.substring(0, index));
            name = new String(name.substring(index + 1));
        } else {
            this.schema = null;
        }
        super.setShortName(name);
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
        this.outputDefinition = definition;
    }

    public String getOutputDefinition() {
        return this.outputDefinition;
    }

    public void setOutputDefinition(String outputDefinition) {
        this.outputDefinition = outputDefinition;
    }

    public boolean isProcedure() {
        return this.isProcedure;
    }

    public void setProcedure(boolean isProcedure) {
        this.isProcedure = isProcedure;
    }

    public void setIsTempTable(boolean isTempTable) {
        this.isTempTable = isTempTable;
    }

    public boolean isTempTable() {
        return this.isTempTable;
    }

    public Object getMetadataID() {
        return this.metadataID;
    }

    public void setMetadataID(Object metadataID) {
        if (metadataID == null) {
            throw new IllegalArgumentException(Messages.getString(Messages.ERR.ERR_015_010_0016, new Object[0]));
        }
        if (this.isImplicitTempGroupSymbol()) {
            this.isTempTable = true;
        }
        this.metadataID = metadataID;
    }

    public String getNonCorrelationName() {
        if (this.definition == null) {
            return this.getName();
        }
        return this.getDefinition();
    }

    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    public String getCanonicalName() {
        if (this.schema != null) {
            return String.valueOf(this.schema) + "." + this.getShortCanonicalName();
        }
        return super.getShortCanonicalName();
    }

    public static boolean isTempGroupName(String name) {
        if (name == null) {
            return false;
        }
        return name.startsWith(TEMP_GROUP_PREFIX);
    }

    public boolean isTempGroupSymbol() {
        return this.isTempTable || this.metadataID == null && this.isImplicitTempGroupSymbol();
    }

    public boolean isImplicitTempGroupSymbol() {
        if (this.getNonCorrelationName() == null) {
            return false;
        }
        return this.getNonCorrelationName().startsWith(TEMP_GROUP_PREFIX);
    }

    public boolean isResolved() {
        return this.metadataID != null;
    }

    public int compareTo(GroupSymbol other) {
        return this.getName().compareTo(other.getName());
    }

    @Override
    public int hashCode() {
        int result = 1;
        if (this.schema != null) {
            result = 31 * result + this.schema.hashCode();
            result = this.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_0) ? 31 * result + (this.getShortName() == null ? 0 : this.getShortName().hashCode()) : 31 * result + (this.getShortCanonicalName() == null ? 0 : this.getShortCanonicalName().hashCode());
            return result;
        }
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupSymbol other = (GroupSymbol)obj;
        if (this.schema == null || other.schema == null) {
            if (this.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_0)) {
                return this.getCanonicalName().equals(other.getCanonicalName());
            }
            return this.getName().equals(other.getName());
        }
        if (this.schema == null ? other.schema != null : !this.schema.equals(other.schema)) {
            return false;
        }
        if (this.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_0)) {
            return this.getShortCanonicalName().equals(other.getShortCanonicalName());
        }
        return this.getShortName().equals(other.getShortName());
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public GroupSymbol clone() {
        GroupSymbol clone = new GroupSymbol(this.parser, this.id);
        if (this.getDefinition() != null) {
            clone.setDefinition(this.getDefinition());
        }
        if (this.getOutputDefinition() != null) {
            clone.setOutputDefinition(this.getOutputDefinition());
        }
        if (this.getShortCanonicalName() != null) {
            clone.setShortCanonicalName(this.getShortCanonicalName());
        }
        if (this.getOutputName() != null) {
            clone.setOutputName(this.getOutputName());
        }
        if (this.getShortName() != null) {
            clone.setShortName(this.getShortName());
        }
        if (this.getName() != null) {
            clone.setName(this.getName());
        }
        if (this.getMetadataID() != null) {
            clone.setMetadataID(this.getMetadataID());
        }
        clone.setIsTempTable(this.isTempTable);
        clone.setProcedure(this.isProcedure);
        return clone;
    }
}

