/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import org.teiid.designer.annotation.Removed;
import org.teiid.designer.query.sql.symbol.ISymbol;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.SimpleNode;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.runtime.client.Messages;

public class Symbol
extends SimpleNode
implements ISymbol<LanguageVisitor> {
    public static final String SEPARATOR = ".";
    private String shortName;
    protected String outputName;
    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    private String canonicalShortName;

    public static String getShortName(Expression ex) {
        if (ex instanceof Symbol) {
            return ((Symbol)((Object)ex)).getShortName();
        }
        return "expr";
    }

    public static String getShortName(String name) {
        int index = name.lastIndexOf(SEPARATOR);
        if (index >= 0) {
            return name.substring(index + 1);
        }
        return name;
    }

    public Symbol(TeiidParser p, int i) {
        super(p, i);
    }

    public void setName(String name) {
        this.setShortName(name);
    }

    public final String getShortName() {
        return this.shortName;
    }

    public void setShortName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(Messages.getString(Messages.ERR.ERR_015_010_0017, new Object[0]));
        }
        this.shortName = name;
        this.outputName = null;
    }

    public String getName() {
        return this.getShortName();
    }

    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    public String getShortCanonicalName() {
        if (this.canonicalShortName == null && this.shortName != null) {
            this.canonicalShortName = this.shortName.toUpperCase();
        }
        return this.canonicalShortName;
    }

    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    public void setShortCanonicalName(String canonicalShortName) {
        this.canonicalShortName = canonicalShortName;
    }

    public String getOutputName() {
        return this.outputName == null ? this.getName() : this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_0) ? 31 * result + (this.getShortCanonicalName() == null ? 0 : this.getShortCanonicalName().hashCode()) : 31 * result + (this.getShortName() == null ? 0 : this.getShortName().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Symbol other = (Symbol)obj;
        if (this.getShortCanonicalName() == null ? other.getShortCanonicalName() != null : !this.getShortCanonicalName().equalsIgnoreCase(other.getShortCanonicalName())) {
            return false;
        }
        return !(this.getName() == null ? other.getName() != null : !this.getName().equalsIgnoreCase(other.getName()));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Symbol clone() {
        Symbol clone = new Symbol(this.parser, this.id);
        if (this.getShortCanonicalName() != null) {
            clone.setShortCanonicalName(this.getShortCanonicalName());
        }
        if (this.outputName != null) {
            clone.outputName = this.outputName;
        }
        if (this.getShortName() != null) {
            clone.setShortName(this.getShortName());
        }
        if (this.getName() != null) {
            clone.setName(this.getName());
        }
        return clone;
    }
}

