/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol.v8;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.query.sql.symbol.IAggregateSymbol;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.v8.Teiid8Parser;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;

public class Aggregate8Symbol
extends Function
implements AggregateSymbol {
    private boolean distinct;
    private OrderBy orderBy;
    private Expression condition;
    private IAggregateSymbol.Type aggregate;
    private boolean isWindowed;
    private static final Map<String, IAggregateSymbol.Type> nameMap = new TreeMap<String, IAggregateSymbol.Type>(String.CASE_INSENSITIVE_ORDER);
    private static final Class<?> COUNT_TYPE;
    private static final Map<Class<?>, Class<?>> SUM_TYPES;
    private static final Map<Class<?>, Class<?>> AVG_TYPES;

    static {
        IAggregateSymbol.Type[] typeArray = IAggregateSymbol.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAggregateSymbol.Type t = typeArray[n2];
            if (t != IAggregateSymbol.Type.USER_DEFINED) {
                nameMap.put(t.name(), t);
            }
            ++n2;
        }
        COUNT_TYPE = DataTypeManagerService.DefaultDataTypes.INTEGER.getTypeClass();
        Class<?> byteClass = DataTypeManagerService.DefaultDataTypes.BYTE.getTypeClass();
        Class<?> longClass = DataTypeManagerService.DefaultDataTypes.LONG.getTypeClass();
        Class<?> shortClass = DataTypeManagerService.DefaultDataTypes.SHORT.getTypeClass();
        Class<?> integerClass = DataTypeManagerService.DefaultDataTypes.INTEGER.getTypeClass();
        Class<?> doubleClass = DataTypeManagerService.DefaultDataTypes.DOUBLE.getTypeClass();
        Class<?> bigDecimalClass = DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL.getTypeClass();
        Class<?> bigIntegerClass = DataTypeManagerService.DefaultDataTypes.BIG_INTEGER.getTypeClass();
        Class<?> floatClass = DataTypeManagerService.DefaultDataTypes.FLOAT.getTypeClass();
        SUM_TYPES = new HashMap();
        SUM_TYPES.put(byteClass, longClass);
        SUM_TYPES.put(shortClass, longClass);
        SUM_TYPES.put(integerClass, longClass);
        SUM_TYPES.put(longClass, longClass);
        SUM_TYPES.put(bigIntegerClass, bigIntegerClass);
        SUM_TYPES.put(floatClass, doubleClass);
        SUM_TYPES.put(doubleClass, doubleClass);
        SUM_TYPES.put(bigDecimalClass, bigDecimalClass);
        AVG_TYPES = new HashMap();
        DataTypeManagerService dataTypeManager = DataTypeManagerService.getInstance(TeiidServerVersion.Version.TEIID_8_0.get());
        if (dataTypeManager.isDecimalAsDouble()) {
            AVG_TYPES.put(byteClass, doubleClass);
            AVG_TYPES.put(shortClass, doubleClass);
            AVG_TYPES.put(integerClass, doubleClass);
            AVG_TYPES.put(longClass, doubleClass);
        } else {
            AVG_TYPES.put(byteClass, bigDecimalClass);
            AVG_TYPES.put(shortClass, bigDecimalClass);
            AVG_TYPES.put(integerClass, bigDecimalClass);
            AVG_TYPES.put(longClass, bigDecimalClass);
        }
        AVG_TYPES.put(bigIntegerClass, bigDecimalClass);
        AVG_TYPES.put(floatClass, doubleClass);
        AVG_TYPES.put(doubleClass, doubleClass);
        AVG_TYPES.put(bigDecimalClass, bigDecimalClass);
    }

    public Aggregate8Symbol(Teiid8Parser p, int id) {
        super(p, id);
    }

    @Override
    public boolean isBoolean() {
        return this.aggregate == IAggregateSymbol.Type.EVERY || this.aggregate == IAggregateSymbol.Type.SOME || this.aggregate == IAggregateSymbol.Type.ANY;
    }

    @Override
    public boolean isEnhancedNumeric() {
        return this.aggregate == IAggregateSymbol.Type.STDDEV_POP || this.aggregate == IAggregateSymbol.Type.STDDEV_SAMP || this.aggregate == IAggregateSymbol.Type.VAR_SAMP || this.aggregate == IAggregateSymbol.Type.VAR_POP;
    }

    private boolean isAnalytical() {
        switch (this.aggregate) {
            case RANK: 
            case DENSE_RANK: 
            case ROW_NUMBER: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.aggregate == null) {
            this.aggregate = nameMap.get(name);
            if (this.aggregate == null) {
                this.aggregate = IAggregateSymbol.Type.USER_DEFINED;
            }
        }
    }

    @Override
    public Class<?> getType() {
        switch (this.aggregate) {
            case COUNT: {
                return COUNT_TYPE;
            }
            case SUM: {
                Class<?> expressionType = this.getArg(0).getType();
                return SUM_TYPES.get(expressionType);
            }
            case AVG: {
                Class<?> expressionType = this.getArg(0).getType();
                return AVG_TYPES.get(expressionType);
            }
            case ARRAY_AGG: {
                if (this.getArg(0) == null) {
                    return null;
                }
                DataTypeManagerService.DefaultDataTypes dataType = this.getTeiidParser().getDataTypeService().getDataType(this.getArg(0).getType());
                return dataType.getTypeArrayClass();
            }
            case TEXTAGG: {
                return DataTypeManagerService.DefaultDataTypes.BLOB.getTypeClass();
            }
            case JSONARRAY_AGG: 
            case USER_DEFINED: {
                return DataTypeManagerService.DefaultDataTypes.CLOB.getTypeClass();
            }
            case STRING_AGG: {
                return super.getType();
            }
        }
        if (this.isBoolean()) {
            return DataTypeManagerService.DefaultDataTypes.BOOLEAN.getTypeClass();
        }
        if (this.isEnhancedNumeric()) {
            return DataTypeManagerService.DefaultDataTypes.DOUBLE.getTypeClass();
        }
        if (this.isAnalytical()) {
            return DataTypeManagerService.DefaultDataTypes.INTEGER.getTypeClass();
        }
        if (this.getArgs().length == 0) {
            return null;
        }
        return this.getArg(0).getType();
    }

    @Override
    public void setAggregateFunction(String aggregateFunction) {
        this.setAggregateFunction(IAggregateSymbol.Type.valueOf((String)aggregateFunction));
    }

    @Override
    public void setAggregateFunction(IAggregateSymbol.Type aggregateFunction) {
        this.aggregate = aggregateFunction;
    }

    @Override
    public IAggregateSymbol.Type getAggregateFunction() {
        return this.aggregate;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    @Override
    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    @Override
    public void setOrderBy(OrderBy orderBy) {
        this.orderBy = orderBy;
    }

    @Override
    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    @Override
    public boolean isWindowed() {
        return this.isWindowed;
    }

    @Override
    public void setWindowed(boolean isWindowed) {
        this.isWindowed = isWindowed;
    }

    @Override
    public String getCanonicalName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCanonicalName(String canonicalName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.aggregate == null ? 0 : this.aggregate.hashCode());
        result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
        result = 31 * result + (this.distinct ? 1231 : 1237);
        result = 31 * result + (this.isWindowed ? 1231 : 1237);
        result = 31 * result + (this.orderBy == null ? 0 : this.orderBy.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Aggregate8Symbol other = (Aggregate8Symbol)obj;
        if (this.aggregate != other.aggregate) {
            return false;
        }
        if (this.condition == null ? other.condition != null : !this.condition.equals(other.condition)) {
            return false;
        }
        if (this.distinct != other.distinct) {
            return false;
        }
        if (this.isWindowed != other.isWindowed) {
            return false;
        }
        return !(this.orderBy == null ? other.orderBy != null : !this.orderBy.equals(other.orderBy));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Aggregate8Symbol clone() {
        Aggregate8Symbol clone = new Aggregate8Symbol((Teiid8Parser)this.parser, this.id);
        if (this.getAggregateFunction() != null) {
            clone.setAggregateFunction(this.getAggregateFunction());
        }
        if (this.getAggregateFunction() != null) {
            clone.setAggregateFunction(this.getAggregateFunction());
        }
        clone.setDistinct(this.isDistinct());
        if (this.getOrderBy() != null) {
            clone.setOrderBy(this.getOrderBy().clone());
        }
        if (this.getCondition() != null) {
            clone.setCondition(this.getCondition().clone());
        }
        clone.setWindowed(this.isWindowed());
        if (this.getName() != null) {
            clone.setName(this.getName());
        }
        if (this.getArgs() != null) {
            Expression[] cloned = new Expression[this.getArgs().length];
            int i = 0;
            while (i < this.getArgs().length) {
                cloned[i] = this.getArgs()[i].clone();
                ++i;
            }
            clone.setArgs(cloned);
        }
        if (super.getType() != null) {
            clone.setType(super.getType());
        }
        return clone;
    }

    @Override
    public Expression getExpression() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setExpression(Expression expression) {
        throw new UnsupportedOperationException();
    }
}

