/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teiid.core.util.ArgCheck;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;

public class SymbolMap {
    private LinkedHashMap<ElementSymbol, Expression> map = new LinkedHashMap();
    private Map<ElementSymbol, Expression> unmodifiableMap = Collections.unmodifiableMap(this.map);

    public SymbolMap clone() {
        SymbolMap clonedMap = new SymbolMap();
        for (Map.Entry<ElementSymbol, Expression> entry : this.map.entrySet()) {
            clonedMap.addMapping(entry.getKey().clone(), entry.getValue().clone());
        }
        return clonedMap;
    }

    public Map<Expression, ElementSymbol> inserseMapping() {
        HashMap<Expression, ElementSymbol> inverseMap = new HashMap<Expression, ElementSymbol>();
        for (Map.Entry<ElementSymbol, Expression> entry : this.map.entrySet()) {
            inverseMap.put(entry.getValue(), entry.getKey());
        }
        return inverseMap;
    }

    public boolean addMapping(ElementSymbol symbol, Expression expression) {
        return this.map.put(symbol, SymbolMap.getExpression(expression)) == null;
    }

    public static final Expression getExpression(Expression symbol) {
        if (symbol instanceof AliasSymbol) {
            symbol = ((AliasSymbol)symbol).getSymbol();
        }
        if (symbol instanceof ExpressionSymbol) {
            ExpressionSymbol exprSymbol = (ExpressionSymbol)symbol;
            return exprSymbol.getExpression();
        }
        return symbol;
    }

    public Expression getMappedExpression(ElementSymbol symbol) {
        return this.map.get(symbol);
    }

    public Map<ElementSymbol, Expression> asUpdatableMap() {
        return this.map;
    }

    public Map<ElementSymbol, Expression> asMap() {
        return this.unmodifiableMap;
    }

    public List<ElementSymbol> getKeys() {
        return new ArrayList<ElementSymbol>(this.map.keySet());
    }

    public List<Expression> getValues() {
        return new ArrayList<Expression>(this.map.values());
    }

    public static final SymbolMap createSymbolMap(GroupSymbol virtualGroup, List<? extends Expression> projectCols, IQueryMetadataInterface metadata) throws Exception {
        return SymbolMap.createSymbolMap(ResolverUtil.resolveElementsInGroup(virtualGroup, metadata), projectCols);
    }

    public static final SymbolMap createSymbolMap(List<ElementSymbol> virtualElements, List<? extends Expression> mappedCols) {
        ArgCheck.isTrue(virtualElements.size() == mappedCols.size(), "elements must match columns");
        SymbolMap symbolMap = new SymbolMap();
        Iterator<ElementSymbol> keyIter = virtualElements.iterator();
        for (Expression expression : mappedCols) {
            symbolMap.addMapping(keyIter.next(), expression);
        }
        return symbolMap;
    }

    public String toString() {
        return this.map.toString();
    }
}

