/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.ArrayList;
import java.util.List;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.query.sql.ICommandCollectorVisitor;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.LanguageObject;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.LoopStatement;
import org.teiid.query.sql.symbol.ScalarSubquery;

public class CommandCollectorVisitor
extends LanguageVisitor
implements ICommandCollectorVisitor<Command> {
    private List<Command> commands = new ArrayList<Command>();

    public CommandCollectorVisitor(ITeiidServerVersion teiidVersion) {
        super(teiidVersion);
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    @Override
    public void visit(ExistsCriteria obj) {
        this.commands.add(obj.getCommand());
    }

    @Override
    public void visit(ScalarSubquery obj) {
        this.commands.add(obj.getCommand());
    }

    @Override
    public void visit(SubqueryCompareCriteria obj) {
        this.commands.add(obj.getCommand());
    }

    @Override
    public void visit(SubqueryFromClause obj) {
        this.commands.add(obj.getCommand());
    }

    @Override
    public void visit(SubquerySetCriteria obj) {
        this.commands.add(obj.getCommand());
    }

    @Override
    public void visit(CommandStatement obj) {
        this.commands.add(obj.getCommand());
    }

    @Override
    public void visit(LoopStatement obj) {
        this.commands.add(obj.getCommand());
    }

    @Override
    public void visit(WithQueryCommand obj) {
        this.commands.add(obj.getCommand());
    }

    @Override
    @Since(value=TeiidServerVersion.Version.TEIID_8_11)
    public void visit(Insert obj) {
        if (this.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_11)) {
            super.visit(obj);
            return;
        }
        if (obj.getQueryExpression() != null) {
            this.commands.add(obj.getQueryExpression());
        }
    }

    public List<Command> findCommands(Command command) {
        final boolean visitCommands = command instanceof SetQuery;
        PreOrderNavigator navigator = new PreOrderNavigator(this){

            @Override
            protected void visitNode(LanguageObject obj) {
                if (!visitCommands && obj instanceof Command) {
                    return;
                }
                super.visitNode(obj);
            }
        };
        command.acceptVisitor(navigator);
        return this.getCommands();
    }

    public static final List<Command> getCommands(Command command) {
        CommandCollectorVisitor visitor = new CommandCollectorVisitor(command.getTeiidVersion());
        return visitor.findCommands(command);
    }
}

