/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.teiid.designer.query.sql.IElementCollectorVisitor;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.sql.lang.LanguageObject;
import org.teiid.query.sql.navigator.DeepPreOrderNavigator;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.runtime.client.Messages;

public class ElementCollectorVisitor
extends LanguageVisitor
implements IElementCollectorVisitor<LanguageObject, ElementSymbol> {
    private Collection<? super ElementSymbol> elements;
    private boolean aggsOnly;

    public ElementCollectorVisitor(ITeiidServerVersion teiidVersion, boolean removeDuplicates) {
        this(teiidVersion, removeDuplicates ? new HashSet() : new ArrayList());
    }

    public ElementCollectorVisitor(ITeiidServerVersion teiidVersion, Collection<? super ElementSymbol> elements) {
        super(teiidVersion);
        if (elements == null) {
            throw new IllegalArgumentException(Messages.getString(Messages.ERR.ERR_015_010_0021, new Object[0]));
        }
        this.elements = elements;
    }

    @Override
    public void visit(ElementSymbol obj) {
        if (!this.aggsOnly || obj.isAggregate()) {
            this.elements.add(obj);
        }
    }

    @Override
    public void visit(MultipleElementSymbol obj) {
        List<ElementSymbol> elementSymbols = obj.getElementSymbols();
        if (elementSymbols != null) {
            int i = 0;
            while (i < elementSymbols.size()) {
                this.visit(elementSymbols.get(i));
                ++i;
            }
        }
    }

    public static final void getElements(LanguageObject obj, Collection<? super ElementSymbol> elements) {
        if (obj == null) {
            return;
        }
        ElementCollectorVisitor visitor = new ElementCollectorVisitor(obj.getTeiidVersion(), elements);
        PreOrderNavigator.doVisit(obj, visitor);
    }

    public static final void getElements(Collection<? extends LanguageObject> objs, Collection<ElementSymbol> elements) {
        if (objs == null) {
            return;
        }
        LanguageObject obj = objs.iterator().next();
        ElementCollectorVisitor visitor = new ElementCollectorVisitor(obj.getTeiidVersion(), elements);
        for (LanguageObject languageObject : objs) {
            PreOrderNavigator.doVisit(languageObject, visitor);
        }
    }

    public static final Collection<ElementSymbol> getElements(LanguageObject obj, boolean removeDuplicates) {
        return ElementCollectorVisitor.getElements(obj, removeDuplicates, false);
    }

    public static final Collection<ElementSymbol> getElements(LanguageObject obj, boolean removeDuplicates, boolean useDeepIteration) {
        return ElementCollectorVisitor.getElements(obj, removeDuplicates, useDeepIteration, false);
    }

    public static final Collection<ElementSymbol> getElements(LanguageObject obj, boolean removeDuplicates, boolean useDeepIteration, boolean aggsOnly) {
        if (obj == null) {
            return Collections.emptyList();
        }
        AbstractCollection elements = null;
        elements = removeDuplicates ? new LinkedHashSet() : new ArrayList();
        ElementCollectorVisitor visitor = new ElementCollectorVisitor(obj.getTeiidVersion(), elements);
        visitor.aggsOnly = aggsOnly;
        if (useDeepIteration) {
            DeepPreOrderNavigator.doVisit(obj, visitor);
        } else {
            PreOrderNavigator.doVisit(obj, visitor);
        }
        return elements;
    }

    public static final Collection<ElementSymbol> getAggregates(LanguageObject obj, boolean removeDuplicates) {
        return ElementCollectorVisitor.getElements(obj, removeDuplicates, false, true);
    }

    public Collection<? super ElementSymbol> findElements(LanguageObject obj) {
        return this.findElements(obj, false);
    }

    public Collection<? super ElementSymbol> findElements(LanguageObject obj, boolean useDeepIteration) {
        return this.findElements(obj, useDeepIteration, false);
    }

    public Collection<? super ElementSymbol> findElements(LanguageObject obj, boolean useDeepIteration, boolean aggsOnly) {
        this.aggsOnly = aggsOnly;
        if (useDeepIteration) {
            DeepPreOrderNavigator.doVisit(obj, this);
        } else {
            PreOrderNavigator.doVisit(obj, this);
        }
        return this.elements;
    }
}

