/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.teiid.designer.query.sql.IFunctionCollectorVisitor;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.sql.lang.LanguageObject;
import org.teiid.query.sql.navigator.DeepPreOrderNavigator;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.symbol.Function;
import org.teiid.runtime.client.Messages;

public class FunctionCollectorVisitor
extends LanguageVisitor
implements IFunctionCollectorVisitor<LanguageObject, Function> {
    private Collection<Function> functions;
    private String functionName;

    public FunctionCollectorVisitor(ITeiidServerVersion teiidVersion, boolean removeDuplicates) {
        this(teiidVersion, removeDuplicates ? new HashSet() : new ArrayList());
    }

    public FunctionCollectorVisitor(ITeiidServerVersion teiidVersion, Collection<Function> functions) {
        this(teiidVersion, functions, null);
    }

    public FunctionCollectorVisitor(ITeiidServerVersion teiidVersion, Collection<Function> functions, String functionName) {
        super(teiidVersion);
        if (functions == null) {
            throw new IllegalArgumentException(Messages.getString(Messages.ERR.ERR_015_010_0022, new Object[0]));
        }
        this.functions = functions;
        this.functionName = functionName;
    }

    public Collection<Function> getFunctions() {
        return this.functions;
    }

    @Override
    public void visit(Function obj) {
        if (this.functionName == null || obj.getName().equalsIgnoreCase(this.functionName)) {
            this.functions.add(obj);
        }
    }

    public Collection<Function> findFunctions(LanguageObject obj, boolean deep) {
        if (!deep) {
            PreOrderNavigator.doVisit(obj, this);
        } else {
            DeepPreOrderNavigator.doVisit(obj, this);
        }
        return this.functions;
    }

    public static final void getFunctions(LanguageObject obj, Collection<Function> functions) {
        FunctionCollectorVisitor.getFunctions(obj, functions, false);
    }

    public static final void getFunctions(LanguageObject obj, Collection<Function> functions, boolean deep) {
        FunctionCollectorVisitor visitor = new FunctionCollectorVisitor(obj.getTeiidVersion(), functions);
        visitor.findFunctions(obj, deep);
    }

    public static final Collection<Function> getFunctions(LanguageObject obj, boolean removeDuplicates) {
        return FunctionCollectorVisitor.getFunctions(obj, removeDuplicates, false);
    }

    public static final Collection<Function> getFunctions(LanguageObject obj, boolean removeDuplicates, boolean deep) {
        AbstractCollection functions = null;
        functions = removeDuplicates ? new HashSet() : new ArrayList();
        FunctionCollectorVisitor.getFunctions(obj, functions, deep);
        return functions;
    }

    public static boolean isNonDeterministic(LanguageObject ex) {
        Collection<Function> functions = FunctionCollectorVisitor.getFunctions(ex, true, false);
        for (Function function : functions) {
            if (function.getFunctionDescriptor().getDeterministic() != FunctionMethod.Determinism.NONDETERMINISTIC) continue;
            return true;
        }
        return false;
    }
}

