/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.teiid.designer.query.sql.IGroupCollectorVisitor;
import org.teiid.designer.query.sql.ILanguageVisitor;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.LanguageObject;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.navigator.DeepPreOrderNavigator;
import org.teiid.query.sql.navigator.PreOrPostOrderNavigator;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.runtime.client.Messages;

public class GroupCollectorVisitor
extends LanguageVisitor
implements IGroupCollectorVisitor<LanguageObject, GroupSymbol> {
    private Collection<GroupSymbol> groups;
    private boolean isIntoClauseGroup;
    private boolean ignoreInlineViewGroups = false;
    private Collection<GroupSymbol> inlineViewGroups;

    public GroupCollectorVisitor(ITeiidServerVersion teiidVersion, boolean removeDuplicates) {
        this(teiidVersion, removeDuplicates ? new HashSet() : new ArrayList());
    }

    public GroupCollectorVisitor(ITeiidServerVersion teiidVersion, Collection<GroupSymbol> groups) {
        super(teiidVersion);
        if (groups == null) {
            throw new IllegalArgumentException(Messages.getString(Messages.ERR.ERR_015_010_0023, new Object[0]));
        }
        this.groups = groups;
    }

    public Collection<GroupSymbol> getGroups() {
        return this.groups;
    }

    public Collection<GroupSymbol> getInlineViewGroups() {
        return this.inlineViewGroups;
    }

    public void setIgnoreInlineViewGroups(boolean ignoreInlineViewGroups) {
        this.ignoreInlineViewGroups = ignoreInlineViewGroups;
    }

    @Override
    public void visit(GroupSymbol obj) {
        if (this.isIntoClauseGroup) {
            if (!obj.isTempGroupSymbol()) {
                this.groups.add(obj);
            }
            this.isIntoClauseGroup = false;
        } else {
            this.groups.add(obj);
        }
    }

    @Override
    public void visit(StoredProcedure obj) {
        this.groups.add(obj.getGroup());
    }

    @Override
    public void visit(Into obj) {
        this.isIntoClauseGroup = true;
    }

    @Override
    public void visit(SubqueryFromClause obj) {
        if (this.ignoreInlineViewGroups) {
            if (this.inlineViewGroups == null) {
                this.inlineViewGroups = new ArrayList<GroupSymbol>();
            }
            this.inlineViewGroups.add(obj.getGroupSymbol());
        }
    }

    public static void getGroups(LanguageObject obj, Collection<GroupSymbol> groups) {
        GroupCollectorVisitor visitor = new GroupCollectorVisitor(obj.getTeiidVersion(), groups);
        PreOrderNavigator.doVisit(obj, visitor);
    }

    public static Collection<GroupSymbol> getGroups(LanguageObject obj, boolean removeDuplicates) {
        AbstractCollection groups = null;
        groups = removeDuplicates ? new HashSet() : new ArrayList();
        GroupCollectorVisitor visitor = new GroupCollectorVisitor(obj.getTeiidVersion(), groups);
        PreOrderNavigator.doVisit(obj, visitor);
        return groups;
    }

    public static void getGroupsIgnoreInlineViews(LanguageObject obj, Collection<GroupSymbol> groups) {
        GroupCollectorVisitor visitor = new GroupCollectorVisitor(obj.getTeiidVersion(), groups);
        visitor.setIgnoreInlineViewGroups(true);
        DeepPreOrderNavigator.doVisit(obj, visitor);
        if (visitor.getInlineViewGroups() != null) {
            groups.removeAll(visitor.getInlineViewGroups());
        }
    }

    public static Collection<GroupSymbol> getGroupsIgnoreInlineViewsAndEvaluatableSubqueries(LanguageObject obj, boolean removeDuplicates) {
        AbstractCollection groups = null;
        groups = removeDuplicates ? new LinkedHashSet() : new ArrayList();
        GroupCollectorVisitor visitor = new GroupCollectorVisitor(obj.getTeiidVersion(), groups);
        visitor.setIgnoreInlineViewGroups(true);
        if (visitor.isTeiid811OrGreater()) {
            PreOrPostOrderNavigator nav = new PreOrPostOrderNavigator(visitor, true, true);
            nav.setSkipEvaluatable(true);
            obj.acceptVisitor((ILanguageVisitor)nav);
        } else {
            DeepPreOrderNavigator.doVisit(obj, visitor);
        }
        if (visitor.getInlineViewGroups() != null) {
            groups.removeAll(visitor.getInlineViewGroups());
        }
        return groups;
    }

    public Collection<GroupSymbol> findGroups(LanguageObject obj) {
        PreOrderNavigator.doVisit(obj, this);
        return this.groups;
    }

    public Collection<GroupSymbol> findGroupsIgnoreInlineViews(LanguageObject obj) {
        this.setIgnoreInlineViewGroups(true);
        DeepPreOrderNavigator.doVisit(obj, this);
        if (this.getInlineViewGroups() != null) {
            this.groups.removeAll(this.getInlineViewGroups());
        }
        return this.groups;
    }
}

