/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CriteriaSelector;
import org.teiid.query.sql.lang.LanguageObject;
import org.teiid.query.sql.lang.TranslateCriteria;
import org.teiid.query.sql.navigator.DeepPreOrderNavigator;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;

public class ResolveVirtualGroupCriteriaVisitor
extends LanguageVisitor {
    private List virtualGroup;
    private IQueryMetadataInterface metadata;

    public ResolveVirtualGroupCriteriaVisitor(ITeiidServerVersion teiidVersion, GroupSymbol virtualGroup, IQueryMetadataInterface metadata) {
        super(teiidVersion);
        this.virtualGroup = Arrays.asList(virtualGroup);
        this.metadata = metadata;
    }

    @Override
    public void visit(TranslateCriteria obj) {
        if (obj.hasTranslations()) {
            for (CompareCriteria ccrit : obj.getTranslations()) {
                ElementSymbol element = (ElementSymbol)ccrit.getLeftExpression();
                try {
                    ResolverVisitor resolverVisitor = new ResolverVisitor(this.getTeiidVersion());
                    resolverVisitor.resolveLanguageObject(element, (Collection<GroupSymbol>)this.virtualGroup, this.metadata);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public void visit(CriteriaSelector obj) {
        if (obj.hasElements()) {
            for (ElementSymbol virtualElement : obj.getElements()) {
                try {
                    ResolverVisitor resolverVisitor = new ResolverVisitor(this.getTeiidVersion());
                    resolverVisitor.resolveLanguageObject(virtualElement, (Collection<GroupSymbol>)this.virtualGroup, this.metadata);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void resolveCriteria(LanguageObject obj, GroupSymbol virtualGroup, IQueryMetadataInterface metadata) throws Exception {
        if (obj == null) {
            return;
        }
        ResolveVirtualGroupCriteriaVisitor resolveVisitor = new ResolveVirtualGroupCriteriaVisitor(obj.getTeiidVersion(), virtualGroup, metadata);
        try {
            DeepPreOrderNavigator.doVisit(obj, resolveVisitor);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof QueryResolverException) {
                throw (QueryResolverException)e.getCause();
            }
            throw e;
        }
    }
}

