/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Clob;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.util.LRUCache;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.util.VariableContext;

public class CommandContext
implements Cloneable,
org.teiid.CommandContext {
    private GlobalState globalState = new GlobalState();
    private FunctionMethod.Determinism[] determinismLevel = new FunctionMethod.Determinism[]{FunctionMethod.Determinism.DETERMINISTIC};
    private VariableContext variableContext = new VariableContext();
    private final ITeiidServerVersion teiidVersion;

    public CommandContext(ITeiidServerVersion teiidVersion) {
        this.teiidVersion = teiidVersion;
    }

    public ITeiidServerVersion getTeiidVersion() {
        return this.teiidVersion;
    }

    public VariableContext getVariableContext() {
        return this.variableContext;
    }

    public FunctionMethod.Determinism getDeterminismLevel() {
        return this.determinismLevel[0];
    }

    public void setDeterminismLevel(FunctionMethod.Determinism level) {
        if (this.determinismLevel[0] == null || level.compareTo(this.determinismLevel[0]) < 0) {
            this.determinismLevel[0] = level;
        }
    }

    @Override
    public double getNextRand() {
        if (this.globalState.random == null) {
            this.globalState.random = new Random();
        }
        return this.globalState.random.nextDouble();
    }

    @Override
    public double getNextRand(long seed) {
        if (this.globalState.random == null) {
            this.globalState.random = new Random();
        }
        this.globalState.random.setSeed(seed);
        return this.globalState.random.nextDouble();
    }

    public static DecimalFormat getDecimalFormat(CommandContext context, String format) {
        DecimalFormat result = null;
        if (context != null) {
            if (context.globalState.decimalFormatCache == null) {
                context.globalState.decimalFormatCache = new LRUCache(32);
            } else {
                result = (DecimalFormat)context.globalState.decimalFormatCache.get(format);
            }
        }
        if (result == null) {
            result = new DecimalFormat(format);
            result.setParseBigDecimal(true);
            if (context != null) {
                context.globalState.decimalFormatCache.put(format, result);
            }
        }
        return result;
    }

    public static SimpleDateFormat getDateFormat(CommandContext context, String format) {
        SimpleDateFormat result = null;
        if (context != null) {
            if (context.globalState.dateFormatCache == null) {
                context.globalState.dateFormatCache = new LRUCache(32);
            } else {
                result = (SimpleDateFormat)context.globalState.dateFormatCache.get(format);
            }
        }
        if (result == null) {
            result = new SimpleDateFormat(format);
            if (context != null) {
                context.globalState.dateFormatCache.put(format, result);
            }
        }
        return result;
    }

    public static Pattern getPattern(CommandContext context, String regex, int flags) {
        Pattern result = null;
        if (context != null) {
            if (context.globalState.patternCache == null) {
                context.globalState.patternCache = new LRUCache(32);
            } else {
                result = (Pattern)context.globalState.patternCache.get(new AbstractMap.SimpleEntry<Pattern, Integer>(result, flags));
            }
        }
        if (result == null) {
            result = Pattern.compile(regex, flags);
            if (context != null) {
                context.globalState.patternCache.put(new AbstractMap.SimpleEntry<Pattern, Integer>(result, flags), result);
            }
        }
        return result;
    }

    public Clob getSpatialSysRef() {
        return new ClobImpl(new InputStreamFactory(){

            @Override
            public InputStream getInputStream() {
                return this.getClass().getClassLoader().getResourceAsStream("org/teiid/metadata/spatial_ref_sys.csv");
            }
        }, -1L);
    }

    @Override
    public String getUserName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getVdbName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getVdbVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getConnectionId() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public String getConnectionID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getProcessorBatchSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TimeZone getServerTimeZone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Subject getSubject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Serializable getCommandPayload() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRequestId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getReuseCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassLoader getVDBClassLoader() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addWarning(Exception ex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isContinuous() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isReturnAutoGeneratedKeys() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSessionVariableCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object setSessionVariable(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getSessionVariable(String key) {
        throw new UnsupportedOperationException();
    }

    public Clob getSpatialRefSys() {
        return new ClobImpl(new InputStreamFactory(){

            @Override
            public InputStream getInputStream() throws IOException {
                return this.getClass().getClassLoader().getResourceAsStream("org/teiid/metadata/spatial_ref_sys.csv");
            }
        }, -1L);
    }

    public void addCreatedLob(InputStreamFactory isf) {
    }

    public void disableAutoCleanLobs() {
    }

    private static class GlobalState
    implements Cloneable {
        private Random random = null;
        private LRUCache<String, DecimalFormat> decimalFormatCache;
        private LRUCache<String, SimpleDateFormat> dateFormatCache;
        private LRUCache<Map.Entry<String, Integer>, Pattern> patternCache;

        private GlobalState() {
        }
    }
}

