/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.validator;

import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.query.sql.ILanguageVisitor;
import org.teiid.designer.validator.IValidator;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.LanguageObject;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.visitor.CommandCollectorVisitor;
import org.teiid.query.validator.AbstractValidationVisitor;
import org.teiid.query.validator.ValidationVisitor;
import org.teiid.query.validator.ValidatorReport;

public class Validator
implements IValidator<LanguageObject> {
    public ValidatorReport validate(LanguageObject object, IQueryMetadataInterface metadata) throws Exception {
        ValidatorReport report1 = Validator.validate(object, metadata, new ValidationVisitor(object.getTeiidVersion()));
        return report1;
    }

    public static final ValidatorReport validate(LanguageObject object, IQueryMetadataInterface metadata, AbstractValidationVisitor visitor) throws Exception {
        Validator.executeValidation(object, metadata, visitor);
        if (object instanceof Command) {
            for (Command subCommand : CommandCollectorVisitor.getCommands((Command)object)) {
                Validator.validate(subCommand, metadata, visitor);
            }
        }
        return visitor.getReport();
    }

    private static final void executeValidation(LanguageObject object, final IQueryMetadataInterface metadata, final AbstractValidationVisitor visitor) throws Exception {
        visitor.reset();
        visitor.setMetadata(metadata);
        Validator.setTempMetadata(metadata, visitor, object);
        PreOrderNavigator nav = new PreOrderNavigator((LanguageVisitor)visitor){

            @Override
            protected void visitNode(LanguageObject obj) {
                IQueryMetadataInterface previous = visitor.getMetadata();
                Validator.setTempMetadata(metadata, visitor, obj);
                super.visitNode(obj);
                visitor.setMetadata(previous);
            }

            @Override
            protected void preVisitVisitor(LanguageObject obj) {
                super.preVisitVisitor(obj);
                visitor.stack.add(obj);
            }

            @Override
            protected void postVisitVisitor(LanguageObject obj) {
                visitor.stack.pop();
            }
        };
        object.acceptVisitor((ILanguageVisitor)nav);
        Exception e = visitor.getException();
        if (e != null) {
            throw e;
        }
    }

    private static void setTempMetadata(IQueryMetadataInterface metadata, AbstractValidationVisitor visitor, LanguageObject obj) {
        if (obj instanceof Command) {
            Command command;
            visitor.currentCommand = command = (Command)obj;
            TempMetadataStore tempMetadata = command.getTemporaryMetadata();
            if (tempMetadata != null && !tempMetadata.getData().isEmpty()) {
                visitor.setMetadata(new TempMetadataAdapter(metadata, tempMetadata));
            }
        }
    }
}

