/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.xquery.saxon;

import java.util.LinkedList;
import java.util.List;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

class PathMapFilter
extends ProxyReceiver {
    private boolean closed;
    private LinkedList<MatchContext> matchContext = new LinkedList();

    public PathMapFilter(PathMap.PathMapRoot root, Receiver receiver) {
        super(receiver);
        MatchContext mc = new MatchContext();
        mc.bulidContext((PathMap.PathMapNode)root);
        this.matchContext.add(mc);
    }

    public void startElement(NodeName elemName, SchemaType typeCode, int locationId, int properties) throws XPathException {
        MatchContext mc = this.matchContext.getLast();
        MatchContext newContext = new MatchContext();
        if (mc.elementArcs != null) {
            for (PathMap.PathMapArc arc : mc.elementArcs) {
                NodeTest test = arc.getNodeTest();
                if (test == null || test.matches(1, elemName, typeCode.getFingerprint())) {
                    newContext.bulidContext(arc.getTarget());
                    newContext.matchedElement = true;
                }
                if (arc.getAxis() != 4 && arc.getAxis() != 5) continue;
                newContext.processArc(arc);
            }
        }
        this.matchContext.add(newContext);
        if (newContext.matchedElement) {
            super.startElement(elemName, typeCode, locationId, properties);
        }
    }

    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        MatchContext mc = this.matchContext.getLast();
        if (!mc.matchedElement) {
            return;
        }
        if (nameCode.isInNamespace("http://www.w3.org/2001/XMLSchema-instance")) {
            super.attribute(nameCode, typeCode, value, locationId, properties);
            return;
        }
        if (mc.attributeArcs != null) {
            for (PathMap.PathMapArc arc : mc.attributeArcs) {
                NodeTest test = arc.getNodeTest();
                if (test != null && !test.matches(2, nameCode, typeCode.getFingerprint())) continue;
                super.attribute(nameCode, typeCode, value, locationId, properties);
                return;
            }
        }
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        MatchContext context = this.matchContext.getLast();
        if (context.matchedElement && context.matchesText) {
            super.characters(chars, locationId, properties);
        }
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        MatchContext context = this.matchContext.getLast();
        if (context.matchedElement && context.matchesComment) {
            super.comment(chars, locationId, properties);
        }
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        MatchContext context = this.matchContext.getLast();
        if (context.matchedElement) {
            super.processingInstruction(target, data, locationId, properties);
        }
    }

    public void namespace(NamespaceBinding namespaceBinding, int properties) throws XPathException {
        MatchContext context = this.matchContext.getLast();
        if (context.matchedElement) {
            super.namespace(namespaceBinding, properties);
        }
    }

    public void endElement() throws XPathException {
        MatchContext context = this.matchContext.removeLast();
        if (context.matchedElement) {
            super.endElement();
        }
    }

    public void startContent() throws XPathException {
        MatchContext context = this.matchContext.getLast();
        if (context.matchedElement) {
            super.startContent();
        }
    }

    public void close() throws XPathException {
        if (!this.closed) {
            super.close();
            this.closed = true;
        }
    }

    static class MatchContext {
        List<PathMap.PathMapArc> elementArcs;
        List<PathMap.PathMapArc> attributeArcs;
        boolean matchedElement;
        boolean matchesText;
        boolean matchesComment;

        MatchContext() {
        }

        void bulidContext(PathMap.PathMapNode node) {
            PathMap.PathMapArc[] pathMapArcArray = node.getArcs();
            int n = pathMapArcArray.length;
            int n2 = 0;
            while (n2 < n) {
                PathMap.PathMapArc arc = pathMapArcArray[n2];
                this.processArc(arc);
                ++n2;
            }
        }

        void processArc(PathMap.PathMapArc arc) {
            NodeTest test = arc.getNodeTest();
            if (test == null) {
                this.addAnyNodeArc(arc);
            } else {
                switch (test.getPrimitiveType()) {
                    case 3: {
                        this.matchesText = true;
                    }
                    case 0: {
                        this.addAnyNodeArc(arc);
                        break;
                    }
                    case 8: {
                        this.matchesComment = true;
                        break;
                    }
                    case 1: {
                        this.addElementArc(arc);
                        break;
                    }
                    case 2: {
                        this.addAttributeArc(arc);
                    }
                }
            }
        }

        private void addAnyNodeArc(PathMap.PathMapArc arc) {
            if (arc.getAxis() == 2) {
                this.addAttributeArc(arc);
                return;
            }
            this.addElementArc(arc);
            this.addAttributeArc(arc);
            this.matchesText = true;
            this.matchesComment = true;
        }

        private void addAttributeArc(PathMap.PathMapArc arc) {
            if (this.attributeArcs == null) {
                this.attributeArcs = new LinkedList<PathMap.PathMapArc>();
            }
            this.attributeArcs.add(arc);
        }

        private void addElementArc(PathMap.PathMapArc arc) {
            if (this.elementArcs == null) {
                this.elementArcs = new LinkedList<PathMap.PathMapArc>();
            }
            this.elementArcs.add(arc);
        }
    }
}

