/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.xquery.saxon;

import java.io.IOException;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.event.FilterFactory;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.AugmentedSource;
import org.teiid.query.xquery.saxon.ContentHandlerProxyReceiver;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

final class SaxonReader
implements XMLReader {
    private ContentHandler handler;
    private LexicalHandler lexicalHandler;
    private Configuration config;
    private AugmentedSource source;

    public SaxonReader(Configuration config, AugmentedSource source) {
        this.config = config;
        this.source = source;
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            this.lexicalHandler = (LexicalHandler)value;
        }
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.handler = handler;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        final ContentHandlerProxy chp = new ContentHandlerProxy();
        chp.setLexicalHandler(this.lexicalHandler);
        chp.setUnderlyingContentHandler(this.handler);
        this.source.addFilter(new FilterFactory(){

            public ProxyReceiver makeFilter(Receiver arg0) {
                return new ContentHandlerProxyReceiver((Receiver)chp, arg0);
            }
        });
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public EntityResolver getEntityResolver() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DTDHandler getDTDHandler() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.handler;
    }
}

