/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime.client;

import java.io.File;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.services.PluginResourceLocator;
import org.osgi.framework.BundleContext;
import org.teiid.core.util.ArgCheck;

public class TeiidRuntimePlugin
extends Plugin {
    public static String PLUGIN_ID;
    private static final String TARGET = "target";
    private static final String SOURCES = "sources";
    private static final String JAR = "jar";
    public static ILog LOGGER;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        LOGGER = this.getLog();
        PLUGIN_ID = context.getBundle().getSymbolicName();
    }

    public static void log(int severity, Throwable t, String message) {
        ArgCheck.isNotNull(LOGGER);
        LOGGER.log((IStatus)new Status(severity, PLUGIN_ID, message, t));
    }

    public static void logError(String context, Throwable e, Object message) {
        String msg = String.valueOf(context) + " : " + message;
        TeiidRuntimePlugin.log(4, e, msg);
    }

    public static void logError(String context, Object message) {
        String msg = String.valueOf(context) + " : " + message;
        TeiidRuntimePlugin.log(4, null, msg);
    }

    private static String findPluginJar(IPath path) {
        String osPath;
        File jarFile;
        if (path == null) {
            return null;
        }
        if (!path.getFileExtension().equals(JAR)) {
            path = path.addFileExtension(JAR);
        }
        if ((jarFile = new File(osPath = path.toOSString())).exists()) {
            return osPath;
        }
        return null;
    }

    private static String findTargetJar(IPath path) {
        if (path == null) {
            return null;
        }
        File targetDir = new File((path = path.append(TARGET)).toOSString());
        if (!targetDir.isDirectory()) {
            return null;
        }
        File[] fileArray = targetDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith(JAR) && !file.getName().contains(SOURCES) && file.getName().startsWith(PLUGIN_ID)) {
                return file.getAbsolutePath();
            }
            ++n2;
        }
        return null;
    }

    public static String getPluginPath() {
        IPath path = PluginResourceLocator.getPluginRootPath((String)PLUGIN_ID);
        String jarPath = TeiidRuntimePlugin.findPluginJar(path);
        if (jarPath == null) {
            jarPath = TeiidRuntimePlugin.findTargetJar(path);
        }
        return jarPath;
    }
}

