/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime.client.admin;

import java.sql.Driver;
import java.util.HashMap;
import java.util.Map;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.runtime.spi.IExecutionAdmin;
import org.teiid.designer.runtime.spi.IExecutionAdminFactory;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.runtime.client.TeiidRuntimePlugin;
import org.teiid.runtime.client.admin.ExecutionAdmin;
import org.teiid.runtime.client.query.QueryService;

public class ExecutionAdminFactory
implements IExecutionAdminFactory {
    private final Map<ITeiidServerVersion, DataTypeManagerService> dataTypeManagerServiceCache = new HashMap<ITeiidServerVersion, DataTypeManagerService>();
    private final Map<ITeiidServerVersion, QueryService> queryServiceCache = new HashMap<ITeiidServerVersion, QueryService>();

    public IExecutionAdminFactory.SupportLevel supports(ITeiidServerVersion version) {
        if (version == null) {
            return IExecutionAdminFactory.SupportLevel.NO_SUPPORT;
        }
        if (version.isLessThan(TeiidServerVersion.Version.TEIID_7_7)) {
            return IExecutionAdminFactory.SupportLevel.NO_SUPPORT;
        }
        ITeiidServerVersion defaultVersion = TeiidServerVersion.Version.TEIID_DEFAULT.get();
        TeiidServerVersion mmVersion = new TeiidServerVersion(defaultVersion.getMajor(), defaultVersion.getMinor(), "x");
        if (version.isLessThanOrEqualTo((ITeiidServerVersion)mmVersion)) {
            return IExecutionAdminFactory.SupportLevel.FULL_SUPPORT;
        }
        return IExecutionAdminFactory.SupportLevel.WORKS;
    }

    public IExecutionAdmin createExecutionAdmin(ITeiidServer teiidServer) throws Exception {
        return new ExecutionAdmin(teiidServer);
    }

    public IDataTypeManagerService getDataTypeManagerService(ITeiidServerVersion teiidVersion) {
        DataTypeManagerService dataTypeManagerService = this.dataTypeManagerServiceCache.get(teiidVersion);
        if (dataTypeManagerService == null) {
            dataTypeManagerService = DataTypeManagerService.getInstance(teiidVersion);
            this.dataTypeManagerServiceCache.put(teiidVersion, dataTypeManagerService);
        }
        return dataTypeManagerService;
    }

    public Driver getTeiidDriver(ITeiidServerVersion teiidVersion) {
        TeiidDriver instance = TeiidDriver.getInstance();
        instance.setTeiidVersion(teiidVersion);
        return instance;
    }

    public IQueryService getQueryService(ITeiidServerVersion teiidVersion) {
        QueryService queryService = this.queryServiceCache.get(teiidVersion);
        if (queryService == null) {
            queryService = new QueryService(teiidVersion);
            this.queryServiceCache.put(teiidVersion, queryService);
        }
        return queryService;
    }

    public String getRuntimePluginPath() {
        return TeiidRuntimePlugin.getPluginPath();
    }
}

