/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime.client.admin.v7;

import java.io.InputStream;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.VDB;
import org.teiid.designer.runtime.spi.ITeiidAdminInfo;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.runtime.client.admin.AdminSpec;
import org.teiid.runtime.client.admin.v7.Admin7Factory;

public class Admin7Spec
extends AdminSpec {
    public static final String TEST_VDB = "<vdb name=\"ping\" version=\"1\"><model visible=\"true\" name=\"Foo\" type=\"VIRTUAL\" path=\"/dummy/Foo\"><source name=\"s\" translator-name=\"loopback\"/></model></vdb>";

    public Admin7Spec(ITeiidServerVersion teiidVersion) {
        super(teiidVersion);
    }

    @Override
    public Admin createAdmin(ITeiidServer teiidServer) throws AdminException {
        ITeiidAdminInfo teiidAdminInfo = teiidServer.getTeiidAdminInfo();
        char[] passwordArray = null;
        if (teiidAdminInfo.getPassword() != null) {
            passwordArray = teiidAdminInfo.getPassword().toCharArray();
        }
        Admin admin = Admin7Factory.getInstance().createAdmin(teiidAdminInfo.getUsername(), passwordArray, teiidAdminInfo.getUrl());
        return admin;
    }

    @Override
    public String getTestVDB() {
        return TEST_VDB;
    }

    @Override
    public VDB.Status getLoadingVDBStatus() {
        return VDB.Status.ACTIVE;
    }

    @Override
    public void deploy(Admin admin, String fileName, InputStream iStream) throws AdminException {
        admin.deployVDB(fileName, iStream);
    }

    @Override
    public void undeploy(Admin admin, String vdbName, int version) {
        if ("ping-vdb.xml".equals(vdbName)) {
            vdbName = "ping";
        }
        admin.deleteVDB(vdbName, version);
    }
}

