/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime.client.query;

import java.util.ArrayList;
import java.util.List;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.metadata.IMetadataID;
import org.teiid.designer.query.metadata.IQueryNode;
import org.teiid.designer.query.metadata.IStoredProcedureInfo;
import org.teiid.designer.query.sql.lang.IBetweenCriteria;
import org.teiid.designer.query.sql.lang.ICompareCriteria;
import org.teiid.designer.query.sql.lang.ICompoundCriteria;
import org.teiid.designer.query.sql.lang.IDelete;
import org.teiid.designer.query.sql.lang.IExistsCriteria;
import org.teiid.designer.query.sql.lang.IFrom;
import org.teiid.designer.query.sql.lang.IGroupBy;
import org.teiid.designer.query.sql.lang.IInsert;
import org.teiid.designer.query.sql.lang.IIsNullCriteria;
import org.teiid.designer.query.sql.lang.IJoinPredicate;
import org.teiid.designer.query.sql.lang.IJoinType;
import org.teiid.designer.query.sql.lang.IMatchCriteria;
import org.teiid.designer.query.sql.lang.INotCriteria;
import org.teiid.designer.query.sql.lang.IOption;
import org.teiid.designer.query.sql.lang.IOrderBy;
import org.teiid.designer.query.sql.lang.IQuery;
import org.teiid.designer.query.sql.lang.ISPParameter;
import org.teiid.designer.query.sql.lang.ISelect;
import org.teiid.designer.query.sql.lang.ISetCriteria;
import org.teiid.designer.query.sql.lang.ISetQuery;
import org.teiid.designer.query.sql.lang.IStoredProcedure;
import org.teiid.designer.query.sql.lang.ISubqueryCompareCriteria;
import org.teiid.designer.query.sql.lang.ISubqueryFromClause;
import org.teiid.designer.query.sql.lang.ISubquerySetCriteria;
import org.teiid.designer.query.sql.lang.IUnaryFromClause;
import org.teiid.designer.query.sql.lang.IUpdate;
import org.teiid.designer.query.sql.proc.IAssignmentStatement;
import org.teiid.designer.query.sql.proc.IBlock;
import org.teiid.designer.query.sql.proc.ICommandStatement;
import org.teiid.designer.query.sql.proc.ICreateProcedureCommand;
import org.teiid.designer.query.sql.proc.IDeclareStatement;
import org.teiid.designer.query.sql.proc.IRaiseStatement;
import org.teiid.designer.query.sql.symbol.IAggregateSymbol;
import org.teiid.designer.query.sql.symbol.IAliasSymbol;
import org.teiid.designer.query.sql.symbol.IConstant;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.query.sql.symbol.IExpressionSymbol;
import org.teiid.designer.query.sql.symbol.IFunction;
import org.teiid.designer.query.sql.symbol.IGroupSymbol;
import org.teiid.designer.query.sql.symbol.IMultipleElementSymbol;
import org.teiid.designer.query.sql.symbol.IReference;
import org.teiid.designer.query.sql.symbol.IScalarSubquery;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.StoredProcedureInfo;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.CriteriaOperator;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.LanguageObject;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.proc.DeclareStatement;
import org.teiid.query.sql.proc.RaiseErrorStatement;
import org.teiid.query.sql.proc.RaiseStatement;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;

public class SyntaxFactory
implements IQueryFactory<Expression, Expression, FromClause, ElementSymbol, Command, QueryCommand, Criteria, Constant, Block, Expression, GroupSymbol, JoinType> {
    private TeiidParser teiidParser;
    private final TeiidNodeFactory nodeFactory = TeiidNodeFactory.getInstance();

    public SyntaxFactory(TeiidParser teiidParser) {
        this.teiidParser = teiidParser;
    }

    private boolean isGreaterThanOrEqualTo(TeiidServerVersion.Version teiidVersion) {
        ITeiidServerVersion minVersion = this.teiidParser.getVersion().getMinimumVersion();
        return minVersion.equals(teiidVersion.get()) || minVersion.isGreaterThan(teiidVersion.get());
    }

    private <T extends LanguageObject> T create(TeiidNodeFactory.ASTNodes nodeType) {
        return this.nodeFactory.create(this.teiidParser, nodeType);
    }

    public IFunction createFunction(String name, List<? extends Expression> arguments) {
        if (arguments == null) {
            arguments = new ArrayList<Expression>();
        }
        Function function = (Function)this.create(TeiidNodeFactory.ASTNodes.FUNCTION);
        function.setName(name);
        function.setArgs(arguments.toArray(new Expression[0]));
        return function;
    }

    public IAggregateSymbol createAggregateSymbol(String functionName, IAggregateSymbol.Type functionType, boolean isDistinct, Expression expression) {
        AggregateSymbol aggregateSymbol = (AggregateSymbol)this.create(TeiidNodeFactory.ASTNodes.AGGREGATE_SYMBOL);
        aggregateSymbol.setName(functionName);
        aggregateSymbol.setAggregateFunction(functionType);
        aggregateSymbol.setDistinct(isDistinct);
        if (expression != null) {
            if (this.isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_0)) {
                aggregateSymbol.setArgs(new Expression[]{expression});
            } else {
                aggregateSymbol.setExpression(expression);
            }
        }
        return aggregateSymbol;
    }

    public IElementSymbol createElementSymbol(String name) {
        ElementSymbol elementSymbol = (ElementSymbol)this.create(TeiidNodeFactory.ASTNodes.ELEMENT_SYMBOL);
        elementSymbol.setName(name);
        return elementSymbol;
    }

    public IElementSymbol createElementSymbol(String name, boolean displayFullyQualified) {
        ElementSymbol elementSymbol = (ElementSymbol)this.create(TeiidNodeFactory.ASTNodes.ELEMENT_SYMBOL);
        elementSymbol.setName(name);
        if (displayFullyQualified) {
            elementSymbol.setDisplayMode(IElementSymbol.DisplayMode.FULLY_QUALIFIED);
        } else {
            elementSymbol.setDisplayMode(IElementSymbol.DisplayMode.SHORT_OUTPUT_NAME);
        }
        return elementSymbol;
    }

    public IAliasSymbol createAliasSymbol(String name, Expression symbol) {
        AliasSymbol aliasSymbol = (AliasSymbol)this.create(TeiidNodeFactory.ASTNodes.ALIAS_SYMBOL);
        aliasSymbol.setName(name);
        aliasSymbol.setSymbol(symbol);
        return aliasSymbol;
    }

    public IGroupSymbol createGroupSymbol(String name) {
        GroupSymbol groupSymbol = (GroupSymbol)this.create(TeiidNodeFactory.ASTNodes.GROUP_SYMBOL);
        groupSymbol.setName(name);
        return groupSymbol;
    }

    public IGroupSymbol createGroupSymbol(String name, String definition) {
        GroupSymbol groupSymbol = (GroupSymbol)this.create(TeiidNodeFactory.ASTNodes.GROUP_SYMBOL);
        groupSymbol.setName(name);
        groupSymbol.setDefinition(definition);
        return groupSymbol;
    }

    public IExpressionSymbol createExpressionSymbol(String name, Expression expression) {
        ExpressionSymbol expressionSymbol = (ExpressionSymbol)this.create(TeiidNodeFactory.ASTNodes.EXPRESSION_SYMBOL);
        expressionSymbol.setName(name);
        expressionSymbol.setExpression(expression);
        return expressionSymbol;
    }

    public IMultipleElementSymbol createMultipleElementSymbol() {
        MultipleElementSymbol multipleElementSymbol = (MultipleElementSymbol)this.create(TeiidNodeFactory.ASTNodes.MULTIPLE_ELEMENT_SYMBOL);
        return multipleElementSymbol;
    }

    public IConstant createConstant(Object value) {
        Constant constant = (Constant)this.create(TeiidNodeFactory.ASTNodes.CONSTANT);
        constant.setValue(value);
        return constant;
    }

    public IDeclareStatement createDeclareStatement(ElementSymbol variable, String valueType) {
        DeclareStatement declareStatement = (DeclareStatement)this.create(TeiidNodeFactory.ASTNodes.DECLARE_STATEMENT);
        declareStatement.setVariable(variable);
        declareStatement.setVariableType(valueType);
        return declareStatement;
    }

    public ICommandStatement createCommandStatement(Command command) {
        CommandStatement commandStatement = (CommandStatement)this.create(TeiidNodeFactory.ASTNodes.COMMAND_STATEMENT);
        commandStatement.setCommand(command);
        return commandStatement;
    }

    public IRaiseStatement createRaiseStatement(Expression expression) {
        if (this.isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_0)) {
            RaiseStatement raiseStatement = (RaiseStatement)this.create(TeiidNodeFactory.ASTNodes.RAISE_STATEMENT);
            raiseStatement.setExpression(expression);
            return raiseStatement;
        }
        RaiseErrorStatement raiseErrorStatement = (RaiseErrorStatement)this.create(TeiidNodeFactory.ASTNodes.RAISE_ERROR_STATEMENT);
        raiseErrorStatement.setExpression(expression);
        return raiseErrorStatement;
    }

    public IQuery createQuery() {
        Query query = (Query)this.create(TeiidNodeFactory.ASTNodes.QUERY);
        return query;
    }

    public ISetQuery createSetQuery(ISetQuery.Operation operation, boolean all, QueryCommand leftQuery, QueryCommand rightQuery) {
        SetQuery setQuery = (SetQuery)this.create(TeiidNodeFactory.ASTNodes.SET_QUERY);
        setQuery.setLeftQuery(leftQuery);
        setQuery.setAll(all);
        setQuery.setOperation(operation);
        setQuery.setRightQuery(rightQuery);
        return setQuery;
    }

    public ISetQuery createSetQuery(ISetQuery.Operation operation) {
        SetQuery setQuery = (SetQuery)this.create(TeiidNodeFactory.ASTNodes.SET_QUERY);
        setQuery.setOperation(operation);
        return setQuery;
    }

    public ICompareCriteria createCompareCriteria() {
        CompareCriteria compareCriteria = (CompareCriteria)this.create(TeiidNodeFactory.ASTNodes.COMPARE_CRITERIA);
        return compareCriteria;
    }

    public ICompareCriteria createCompareCriteria(Expression expression1, int operator, Expression expression2) {
        CompareCriteria compareCriteria = (CompareCriteria)this.create(TeiidNodeFactory.ASTNodes.COMPARE_CRITERIA);
        compareCriteria.setLeftExpression(expression1);
        compareCriteria.setOperator(CriteriaOperator.Operator.findOperator(operator));
        compareCriteria.setRightExpression(expression2);
        return compareCriteria;
    }

    public IIsNullCriteria createIsNullCriteria() {
        IsNullCriteria isNullCriteria = (IsNullCriteria)this.create(TeiidNodeFactory.ASTNodes.IS_NULL_CRITERIA);
        return isNullCriteria;
    }

    public IIsNullCriteria createIsNullCriteria(Expression expression) {
        IsNullCriteria isNullCriteria = (IsNullCriteria)this.create(TeiidNodeFactory.ASTNodes.IS_NULL_CRITERIA);
        isNullCriteria.setExpression(expression);
        return isNullCriteria;
    }

    public INotCriteria createNotCriteria() {
        NotCriteria notCriteria = (NotCriteria)this.create(TeiidNodeFactory.ASTNodes.NOT_CRITERIA);
        return notCriteria;
    }

    public INotCriteria createNotCriteria(Criteria criteria) {
        NotCriteria notCriteria = (NotCriteria)this.create(TeiidNodeFactory.ASTNodes.NOT_CRITERIA);
        notCriteria.setCriteria(criteria);
        return notCriteria;
    }

    public IMatchCriteria createMatchCriteria() {
        MatchCriteria matchCriteria = (MatchCriteria)this.create(TeiidNodeFactory.ASTNodes.MATCH_CRITERIA);
        return matchCriteria;
    }

    public ISetCriteria createSetCriteria() {
        SetCriteria setCriteria = (SetCriteria)this.create(TeiidNodeFactory.ASTNodes.SET_CRITERIA);
        return setCriteria;
    }

    public ISubquerySetCriteria createSubquerySetCriteria() {
        SubquerySetCriteria subquerySetCriteria = (SubquerySetCriteria)this.create(TeiidNodeFactory.ASTNodes.SUBQUERY_SET_CRITERIA);
        return subquerySetCriteria;
    }

    public ISubquerySetCriteria createSubquerySetCriteria(Expression expression, QueryCommand command) {
        SubquerySetCriteria subquerySetCriteria = (SubquerySetCriteria)this.create(TeiidNodeFactory.ASTNodes.SUBQUERY_SET_CRITERIA);
        subquerySetCriteria.setExpression(expression);
        subquerySetCriteria.setCommand(command);
        return subquerySetCriteria;
    }

    public ISubqueryCompareCriteria createSubqueryCompareCriteria(Expression leftExpression, QueryCommand command, int operator, int predicateQuantifier) {
        SubqueryCompareCriteria subqueryCompareCriteria = (SubqueryCompareCriteria)this.create(TeiidNodeFactory.ASTNodes.SUBQUERY_COMPARE_CRITERIA);
        subqueryCompareCriteria.setLeftExpression(leftExpression);
        subqueryCompareCriteria.setCommand(command);
        subqueryCompareCriteria.setOperator(CriteriaOperator.Operator.findOperator(operator));
        subqueryCompareCriteria.setPredicateQuantifier(SubqueryCompareCriteria.PredicateQuantifier.findQuantifier(predicateQuantifier));
        return subqueryCompareCriteria;
    }

    public IScalarSubquery createScalarSubquery(QueryCommand queryCommand) {
        ScalarSubquery scalarSubquery = (ScalarSubquery)this.create(TeiidNodeFactory.ASTNodes.SCALAR_SUBQUERY);
        scalarSubquery.setCommand(queryCommand);
        return scalarSubquery;
    }

    public IBetweenCriteria createBetweenCriteria(ElementSymbol elementSymbol, Constant constant1, Constant constant2) {
        BetweenCriteria betweenCriteria = (BetweenCriteria)this.create(TeiidNodeFactory.ASTNodes.BETWEEN_CRITERIA);
        betweenCriteria.setExpression(elementSymbol);
        betweenCriteria.setLowerExpression(constant1);
        betweenCriteria.setUpperExpression(constant2);
        return betweenCriteria;
    }

    public ICompoundCriteria createCompoundCriteria(int operator, List<? extends Criteria> criteria) {
        CompoundCriteria compoundCriteria = (CompoundCriteria)this.create(TeiidNodeFactory.ASTNodes.COMPOUND_CRITERIA);
        compoundCriteria.setOperator(operator);
        compoundCriteria.setCriteria(criteria);
        return compoundCriteria;
    }

    public IExistsCriteria createExistsCriteria(QueryCommand queryCommand) {
        ExistsCriteria existsCriteria = (ExistsCriteria)this.create(TeiidNodeFactory.ASTNodes.EXISTS_CRITERIA);
        existsCriteria.setCommand(queryCommand);
        return existsCriteria;
    }

    public IBlock createBlock() {
        Block block = (Block)this.create(TeiidNodeFactory.ASTNodes.BLOCK);
        return block;
    }

    public ICreateProcedureCommand createCreateProcedureCommand(Block block) {
        if (this.isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_0)) {
            CreateProcedureCommand command = (CreateProcedureCommand)this.create(TeiidNodeFactory.ASTNodes.CREATE_PROCEDURE_COMMAND);
            command.setBlock(block);
            return command;
        }
        CreateUpdateProcedureCommand command = (CreateUpdateProcedureCommand)this.create(TeiidNodeFactory.ASTNodes.CREATE_UPDATE_PROCEDURE_COMMAND);
        command.setBlock(block);
        return command;
    }

    public IAssignmentStatement createAssignmentStatement(ElementSymbol elementSymbol, Expression expression) {
        AssignmentStatement assignmentStatement = (AssignmentStatement)this.create(TeiidNodeFactory.ASTNodes.ASSIGNMENT_STATEMENT);
        assignmentStatement.setVariable(elementSymbol);
        assignmentStatement.setExpression(expression);
        return assignmentStatement;
    }

    public IAssignmentStatement createAssignmentStatement(ElementSymbol elementSymbol, QueryCommand queryCommand) {
        AssignmentStatement assignmentStatement = (AssignmentStatement)this.create(TeiidNodeFactory.ASTNodes.ASSIGNMENT_STATEMENT);
        assignmentStatement.setVariable(elementSymbol);
        assignmentStatement.setCommand(queryCommand);
        return assignmentStatement;
    }

    public ISelect createSelect() {
        Select select = (Select)this.create(TeiidNodeFactory.ASTNodes.SELECT);
        return select;
    }

    public ISelect createSelect(List<? extends Expression> symbols) {
        Select select = (Select)this.create(TeiidNodeFactory.ASTNodes.SELECT);
        select.setSymbols(symbols);
        return select;
    }

    public IFrom createFrom() {
        From from = (From)this.create(TeiidNodeFactory.ASTNodes.FROM);
        return from;
    }

    public IFrom createFrom(List<? extends FromClause> fromClauses) {
        From from = (From)this.create(TeiidNodeFactory.ASTNodes.FROM);
        from.setClauses(fromClauses);
        return from;
    }

    public IUnaryFromClause createUnaryFromClause(GroupSymbol symbol) {
        UnaryFromClause unaryFromClause = (UnaryFromClause)this.create(TeiidNodeFactory.ASTNodes.UNARY_FROM_CLAUSE);
        unaryFromClause.setGroup(symbol);
        return unaryFromClause;
    }

    public ISubqueryFromClause createSubqueryFromClause(String name, QueryCommand command) {
        SubqueryFromClause subqueryFromClause = (SubqueryFromClause)this.create(TeiidNodeFactory.ASTNodes.SUBQUERY_FROM_CLAUSE);
        subqueryFromClause.setName(name);
        subqueryFromClause.setCommand(command);
        return subqueryFromClause;
    }

    public IJoinType getJoinType(IJoinType.Types joinType) {
        JoinType join = (JoinType)this.create(TeiidNodeFactory.ASTNodes.JOIN_TYPE);
        join.setKind(joinType);
        return join;
    }

    public IJoinPredicate createJoinPredicate(FromClause leftClause, FromClause rightClause, JoinType joinType) {
        JoinPredicate joinPredicate = (JoinPredicate)this.create(TeiidNodeFactory.ASTNodes.JOIN_PREDICATE);
        joinPredicate.setJoinType(joinType);
        joinPredicate.setLeftClause(leftClause);
        joinPredicate.setRightClause(rightClause);
        return joinPredicate;
    }

    public IJoinPredicate createJoinPredicate(FromClause leftClause, FromClause rightClause, JoinType joinType, List<Criteria> criteria) {
        JoinPredicate joinPredicate = (JoinPredicate)this.create(TeiidNodeFactory.ASTNodes.JOIN_PREDICATE);
        joinPredicate.setJoinType(joinType);
        joinPredicate.setLeftClause(leftClause);
        joinPredicate.setRightClause(rightClause);
        joinPredicate.setJoinCriteria(criteria);
        return joinPredicate;
    }

    public IGroupBy createGroupBy() {
        GroupBy groupBy = (GroupBy)this.create(TeiidNodeFactory.ASTNodes.GROUP_BY);
        return groupBy;
    }

    public IOrderBy createOrderBy() {
        OrderBy orderBy = (OrderBy)this.create(TeiidNodeFactory.ASTNodes.ORDER_BY);
        return orderBy;
    }

    public IOption createOption() {
        Option option = (Option)this.create(TeiidNodeFactory.ASTNodes.OPTION);
        return option;
    }

    public IUpdate createUpdate() {
        Update update = (Update)this.create(TeiidNodeFactory.ASTNodes.UPDATE);
        return update;
    }

    public IDelete createDelete() {
        Delete delete = (Delete)this.create(TeiidNodeFactory.ASTNodes.DELETE);
        return delete;
    }

    public IInsert createInsert() {
        Insert insert = (Insert)this.create(TeiidNodeFactory.ASTNodes.INSERT);
        return insert;
    }

    public IStoredProcedure createStoredProcedure() {
        StoredProcedure storedProcedure = (StoredProcedure)this.create(TeiidNodeFactory.ASTNodes.STORED_PROCEDURE);
        return storedProcedure;
    }

    public ISPParameter createSPParameter(int index, Expression expression) {
        return new SPParameter(this.teiidParser, index, expression);
    }

    public ISPParameter createSPParameter(int index, ISPParameter.ParameterInfo parameterType, String name) {
        return new SPParameter(this.teiidParser, index, parameterType.index(), name);
    }

    public IReference createReference(int index) {
        Reference reference = (Reference)this.create(TeiidNodeFactory.ASTNodes.REFERENCE);
        reference.setIndex(index);
        return reference;
    }

    public IMetadataID createMetadataID(String id, Class clazz) {
        return new TempMetadataID(id, clazz);
    }

    public IStoredProcedureInfo createStoredProcedureInfo() {
        return new StoredProcedureInfo();
    }

    public IQueryNode createQueryNode(String queryPlan) {
        return new QueryNode(queryPlan);
    }
}

