/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime.client.xml;

import java.io.InputStream;
import org.teiid.designer.xml.IMappingAllNode;
import org.teiid.designer.xml.IMappingAttribute;
import org.teiid.designer.xml.IMappingChoiceNode;
import org.teiid.designer.xml.IMappingCriteriaNode;
import org.teiid.designer.xml.IMappingDocument;
import org.teiid.designer.xml.IMappingDocumentFactory;
import org.teiid.designer.xml.IMappingElement;
import org.teiid.designer.xml.IMappingRecursiveElement;
import org.teiid.designer.xml.IMappingSequenceNode;
import org.teiid.query.mapping.xml.MappingAllNode;
import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingChoiceNode;
import org.teiid.query.mapping.xml.MappingCriteriaNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingLoader;
import org.teiid.query.mapping.xml.MappingNodeConstants;
import org.teiid.query.mapping.xml.MappingRecursiveElement;
import org.teiid.query.mapping.xml.MappingSequenceNode;
import org.teiid.query.mapping.xml.Namespace;
import org.teiid.query.parser.TeiidParser;

public class MappingDocumentFactory
implements IMappingDocumentFactory {
    private final TeiidParser teiidParser;

    public MappingDocumentFactory(TeiidParser teiidParser) {
        this.teiidParser = teiidParser;
    }

    public TeiidParser getTeiidParser() {
        return this.teiidParser;
    }

    public IMappingDocument loadMappingDocument(InputStream inputStream, String documentName) throws Exception {
        MappingLoader reader = new MappingLoader(this.getTeiidParser());
        MappingDocument mappingDoc = null;
        mappingDoc = reader.loadDocument(inputStream);
        mappingDoc.setName(documentName);
        return mappingDoc;
    }

    public IMappingDocument createMappingDocument(String encoding, boolean formatted) {
        return new MappingDocument(this.getTeiidParser(), encoding, formatted);
    }

    private Namespace getNamespace(String prefix) {
        if (prefix != null) {
            return new Namespace(prefix);
        }
        return MappingNodeConstants.NO_NAMESPACE;
    }

    private Namespace getNamespace(String prefix, String uri) {
        return new Namespace(prefix, uri);
    }

    public void addNamespace(IMappingElement element, String prefix, String uri) {
        Namespace namespace = this.getNamespace(prefix, uri);
        ((MappingElement)element).addNamespace(namespace);
    }

    public IMappingElement createMappingElement(String name, String nsPrefix) {
        Namespace namespace = this.getNamespace(nsPrefix);
        return new MappingElement(this.getTeiidParser(), name, namespace);
    }

    public IMappingRecursiveElement createMappingRecursiveElement(String name, String nsPrefix, String recursionMappingClass) {
        Namespace namespace = this.getNamespace(nsPrefix);
        return new MappingRecursiveElement(this.getTeiidParser(), name, namespace, recursionMappingClass);
    }

    public IMappingAttribute createMappingAttribute(String name, String nsPrefix) {
        Namespace namespace = this.getNamespace(nsPrefix);
        return new MappingAttribute(this.getTeiidParser(), name, namespace);
    }

    public IMappingCriteriaNode createMappingCriteriaNode(String criteria, boolean isDefault) {
        return new MappingCriteriaNode(this.getTeiidParser(), criteria, isDefault);
    }

    public IMappingChoiceNode createMappingChoiceNode(boolean exceptionOnDefault) {
        return new MappingChoiceNode(this.getTeiidParser(), exceptionOnDefault);
    }

    public IMappingAllNode createMappingAllNode() {
        return new MappingAllNode(this.getTeiidParser());
    }

    public IMappingSequenceNode createMappingSequenceNode() {
        return new MappingSequenceNode(this.getTeiidParser());
    }
}

