/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator;

import java.io.Serializable;
import java.util.Set;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.Comment;

public class CacheDirective
implements Serializable {
    private static final long serialVersionUID = -4119606289701982511L;
    private final TeiidParser teiidParser;
    private Boolean prefersMemory;
    private Boolean updatable;
    private Boolean readAll;
    private Long ttl;
    private Scope scope;
    private Invalidation invalidation = Invalidation.NONE;

    public CacheDirective(TeiidParser teiidParser) {
        this.teiidParser = teiidParser;
    }

    public CacheDirective(TeiidParser teiidParser, Boolean prefersMemory, Long ttl) {
        this(teiidParser);
        this.prefersMemory = prefersMemory;
        this.ttl = ttl;
    }

    public TeiidParser getTeiidParser() {
        return this.teiidParser;
    }

    public ITeiidServerVersion getTeiidVersion() {
        return this.getTeiidParser().getVersion();
    }

    public Set<Comment> getComments() {
        return this.getTeiidParser().getComments();
    }

    public Boolean getPrefersMemory() {
        return this.prefersMemory;
    }

    public void setPrefersMemory(Boolean prefersMemory) {
        this.prefersMemory = prefersMemory;
    }

    public Long getTtl() {
        return this.ttl;
    }

    public void setTtl(Long ttl) {
        this.ttl = ttl;
    }

    public Boolean getUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(Boolean updatable) {
        this.updatable = updatable;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public Boolean getReadAll() {
        return this.readAll;
    }

    public void setReadAll(Boolean readAll) {
        this.readAll = readAll;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CacheDirective)) {
            return false;
        }
        CacheDirective other = (CacheDirective)obj;
        return EquivalenceUtil.areEqual(this.prefersMemory, other.prefersMemory) && EquivalenceUtil.areEqual(this.readAll, other.readAll) && EquivalenceUtil.areEqual(this.ttl, other.ttl) && EquivalenceUtil.areEqual(this.updatable, other.updatable) && EquivalenceUtil.areEqual((Object)this.scope, (Object)other.scope) && EquivalenceUtil.areEqual((Object)this.invalidation, (Object)other.invalidation);
    }

    public int hashCode() {
        return HashCodeUtil.hashCode(1, new Object[]{this.scope, this.ttl, this.updatable});
    }

    public Invalidation getInvalidation() {
        return this.invalidation;
    }

    public void setInvalidation(Invalidation invalidation) {
        this.invalidation = invalidation;
    }

    public static enum Invalidation {
        NONE,
        LAZY,
        IMMEDIATE;

    }

    public static enum Scope {
        NONE,
        SESSION,
        USER,
        VDB;

    }
}

