/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.SingleReplyRequestDecorator;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.message.CompareRequest;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;

public class CompareRequestDecorator
extends SingleReplyRequestDecorator<CompareRequest>
implements CompareRequest {
    private byte[] attrIdBytes;
    private byte[] attrValBytes;
    private int compareRequestLength;
    private int avaLength;

    public CompareRequestDecorator(LdapApiService codec, CompareRequest decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public void setCompareRequestLength(int compareRequestLength) {
        this.compareRequestLength = compareRequestLength;
    }

    public int getCompareRequestLength() {
        return this.compareRequestLength;
    }

    public void setAvaLength(int avaLength) {
        this.avaLength = avaLength;
    }

    public int getAvaLength() {
        return this.avaLength;
    }

    public byte[] getAttrIdBytes() {
        return this.attrIdBytes;
    }

    public void setAttrIdBytes(byte[] attrIdBytes) {
        this.attrIdBytes = attrIdBytes;
    }

    public byte[] getAttrValBytes() {
        return this.attrValBytes;
    }

    public void setAttrValBytes(byte[] attrValBytes) {
        this.attrValBytes = attrValBytes;
    }

    public Dn getName() {
        return ((CompareRequest)this.getDecorated()).getName();
    }

    public CompareRequest setName(Dn name) {
        ((CompareRequest)this.getDecorated()).setName(name);
        return this;
    }

    public Value<?> getAssertionValue() {
        return ((CompareRequest)this.getDecorated()).getAssertionValue();
    }

    public CompareRequest setAssertionValue(String value) {
        ((CompareRequest)this.getDecorated()).setAssertionValue(value);
        return this;
    }

    public CompareRequest setAssertionValue(byte[] value) {
        ((CompareRequest)this.getDecorated()).setAssertionValue(value);
        return this;
    }

    public String getAttributeId() {
        return ((CompareRequest)this.getDecorated()).getAttributeId();
    }

    public CompareRequest setAttributeId(String attrId) {
        ((CompareRequest)this.getDecorated()).setAttributeId(attrId);
        return this;
    }

    public CompareRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    public CompareRequest addControl(Control control) {
        return (CompareRequest)super.addControl(control);
    }

    public CompareRequest addAllControls(Control[] controls) {
        return (CompareRequest)super.addAllControls(controls);
    }

    public CompareRequest removeControl(Control control) {
        return (CompareRequest)super.removeControl(control);
    }

    @Override
    public int computeLength() {
        Dn entry = this.getName();
        int compareRequestLength = 1 + TLV.getNbBytes((int)Dn.getNbBytes((Dn)entry)) + Dn.getNbBytes((Dn)entry);
        byte[] attributeIdBytes = Strings.getBytesUtf8((String)this.getAttributeId());
        int avaLength = 1 + TLV.getNbBytes((int)attributeIdBytes.length) + attributeIdBytes.length;
        this.setAttrIdBytes(attributeIdBytes);
        Value<?> assertionValue = this.getAssertionValue();
        if (assertionValue instanceof BinaryValue) {
            byte[] value = this.getAssertionValue().getBytes();
            avaLength += 1 + TLV.getNbBytes((int)value.length) + value.length;
            this.setAttrValBytes(value);
        } else {
            byte[] value = Strings.getBytesUtf8((String)this.getAssertionValue().getString());
            avaLength += 1 + TLV.getNbBytes((int)value.length) + value.length;
            this.setAttrValBytes(value);
        }
        this.setAvaLength(avaLength);
        this.setCompareRequestLength(compareRequestLength += 1 + TLV.getNbBytes((int)avaLength) + avaLength);
        return 1 + TLV.getNbBytes((int)compareRequestLength) + compareRequestLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)110);
            buffer.put(TLV.getBytes((int)this.getCompareRequestLength()));
            BerValue.encode((ByteBuffer)buffer, (byte[])Dn.getBytes((Dn)this.getName()));
            buffer.put(UniversalTag.SEQUENCE.getValue());
            buffer.put(TLV.getBytes((int)this.getAvaLength()));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04005, (Object[])new Object[0]));
        }
        BerValue.encode((ByteBuffer)buffer, (byte[])this.getAttrIdBytes());
        BerValue.encode((ByteBuffer)buffer, (byte[])this.getAttrValBytes());
        return buffer;
    }
}

