/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.ResourceManager;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.runtime.IServersProvider;

public class DefaultServersProvider
implements IServersProvider {
    private static final String ERROR_MSG = "Programming Error: The DefaultServersProvider is dependent upon the org.eclipse.wst.server.core.ServerCore for providing the parent servers configured in the Server View. The ServerCore needs to beinitialised through a Job and as such is not available until the IDE has been fully loaded. See the DefaultServersProvider class for ways of avoiding this error.";
    private static final String INIT_FIELD_NAME = "initialized";
    private static Field resourceManagerInitField;
    private Object listenerLock = new Object();
    private Collection<IServersProvider.IServersInitialiseListener> listeners = new ArrayList<IServersProvider.IServersInitialiseListener>();

    public DefaultServersProvider() {
        try {
            resourceManagerInitField = ResourceManager.class.getDeclaredField(INIT_FIELD_NAME);
            resourceManagerInitField.setAccessible(true);
            ObserverThread thread = new ObserverThread();
            thread.start();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean isServerCoreInitialised() {
        try {
            return (Boolean)resourceManagerInitField.get(ResourceManager.class);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void checkServerCoreInitialised() {
        if (!this.isServerCoreInitialised()) {
            throw new RuntimeException(ERROR_MSG);
        }
    }

    @Override
    public boolean isInitialised() {
        return this.isServerCoreInitialised();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServerInitialisedListener(IServersProvider.IServersInitialiseListener listener) {
        if (this.isInitialised()) {
            listener.serversInitialised();
            return;
        }
        Object object = this.listenerLock;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServerInitialisedListener(IServersProvider.IServersInitialiseListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void addServerLifecycleListener(IServerLifecycleListener listener) {
        this.checkServerCoreInitialised();
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)listener);
    }

    @Override
    public void removeServerLifecycleListener(IServerLifecycleListener listener) {
        this.checkServerCoreInitialised();
        ServerCore.removeServerLifecycleListener((IServerLifecycleListener)listener);
    }

    @Override
    public IServer[] getServers() {
        this.checkServerCoreInitialised();
        return ServerCore.getServers();
    }

    @Override
    public void addServerStateListener(IServerListener serverStateListener) {
        this.checkServerCoreInitialised();
        IServer[] iServerArray = this.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            server.addServerListener(serverStateListener);
            ++n2;
        }
    }

    @Override
    public void removeServerStateListener(IServerListener serverStateListener) {
        this.checkServerCoreInitialised();
        IServer[] iServerArray = this.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            server.removeServerListener(serverStateListener);
            ++n2;
        }
    }

    private class ObserverThread
    extends Thread {
        public ObserverThread() {
            super(DefaultServersProvider.this + "." + ObserverThread.class.getSimpleName());
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!DefaultServersProvider.this.isServerCoreInitialised()) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ex) {
                    ModelerCore.Util.log((Throwable)ex);
                }
            }
            Object object = DefaultServersProvider.this.listenerLock;
            synchronized (object) {
                Iterator iterator = DefaultServersProvider.this.listeners.iterator();
                while (iterator.hasNext()) {
                    IServersProvider.IServersInitialiseListener listener = (IServersProvider.IServersInitialiseListener)iterator.next();
                    listener.serversInitialised();
                    iterator.remove();
                }
            }
        }
    }
}

