/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime;

import java.net.MalformedURLException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.datatools.connectivity.ConnectivityUtil;
import org.teiid.datatools.connectivity.spi.ISecureStorageProvider;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.TeiidServerUtils;
import org.teiid.designer.runtime.spi.ITeiidConnectionInfo;

public abstract class TeiidConnectionInfo
implements ITeiidConnectionInfo {
    protected static final int DEFAULT_PORT_NUMBER = 0;
    private ISecureStorageProvider secureStorageProvider;
    private String passToken;
    private String passwordStorageKey;
    protected String url;
    private String host;
    private String port;
    private int portNumber = 0;
    private boolean secure;
    private String username;
    boolean settingAllInfo = false;

    protected TeiidConnectionInfo(String host, String port, String username, ISecureStorageProvider secureStorageProvider, String password, boolean secure) {
        this.host = host;
        this.port = port;
        try {
            this.portNumber = Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {
            this.portNumber = 0;
        }
        this.username = username;
        this.secureStorageProvider = secureStorageProvider;
        this.secure = secure;
    }

    protected void initPassword(String password) {
        if (password == null) {
            return;
        }
        this.setPassword(password);
    }

    protected abstract String getPasswordKey();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TeiidConnectionInfo thatInfo = (TeiidConnectionInfo)object;
        String thisHost = this.getHost();
        String thatHost = thatInfo.getHost();
        if (thisHost == null) {
            if (thatHost != null) {
                return false;
            }
        } else {
            if (thatHost == null) {
                return false;
            }
            if (!thisHost.equals(thatHost)) {
                return false;
            }
        }
        if (this.getPort() == null) {
            if (thatInfo.getPort() != null) {
                return false;
            }
        } else {
            if (thatInfo.getPort() == null) {
                return false;
            }
            if (!this.getPort().equals(thatInfo.getPort())) {
                return false;
            }
        }
        if (this.isSecure() != thatInfo.isSecure()) {
            return false;
        }
        if (this.getUsername() == null) {
            if (thatInfo.getUsername() != null) {
                return false;
            }
        } else {
            if (thatInfo.getUsername() == null) {
                return false;
            }
            if (!this.getUsername().equals(thatInfo.getUsername())) {
                return false;
            }
        }
        if (this.getPassword() == null) {
            if (thatInfo.getPassword() != null) {
                return false;
            }
        } else {
            if (thatInfo.getPassword() == null) {
                return false;
            }
            if (!this.getPassword().equals(thatInfo.getPassword())) {
                return false;
            }
        }
        return true;
    }

    public ISecureStorageProvider getSecureStorageProvider() {
        return this.secureStorageProvider;
    }

    private void generateProviderKey() throws Exception {
        if (this.passwordStorageKey == null) {
            if (this.passToken == null) {
                throw new Exception("password token is NULL");
            }
            this.passwordStorageKey = ConnectivityUtil.buildSecureStorageKey(this.getClass(), (String[])new String[]{this.getUrl(), this.passToken});
        }
    }

    private boolean passwordExists() {
        try {
            boolean exists = this.secureStorageProvider.existsInSecureStorage(this.passwordStorageKey, this.getPasswordKey());
            return exists;
        }
        catch (Exception ex) {
            DqpPlugin.Util.log((Throwable)ex);
            return false;
        }
    }

    private String retrievePassword() {
        if (this.passwordStorageKey == null) {
            return null;
        }
        try {
            return this.secureStorageProvider.getFromSecureStorage(this.passwordStorageKey, this.getPasswordKey());
        }
        catch (Exception ex) {
            DqpPlugin.Util.log((Throwable)ex);
            return null;
        }
    }

    private void generatePasswordToken(String password) {
        try {
            this.passToken = ConnectivityUtil.generateHashToken((String[])new String[]{this.getUrl(), password});
        }
        catch (Exception e) {
            DqpPlugin.Util.log((Throwable)e);
        }
    }

    private void storePassword(String password) {
        boolean restoring = false;
        try {
            try {
                if (this.passToken == null) {
                    this.generateUrl();
                    if (ConnectivityUtil.isPasswordToken((String)password)) {
                        this.passToken = password;
                        restoring = true;
                    } else {
                        this.generatePasswordToken(password);
                    }
                    this.generateProviderKey();
                }
                if (!restoring && !this.passwordExists()) {
                    this.secureStorageProvider.storeInSecureStorage(this.passwordStorageKey, this.getPasswordKey(), password);
                }
            }
            catch (Exception e) {
                DqpPlugin.Util.log((Throwable)e);
                restoring = false;
            }
        }
        finally {
            restoring = false;
        }
    }

    private void resetPassword() {
        if (this.settingAllInfo) {
            return;
        }
        String currentPassword = this.retrievePassword();
        try {
            if (this.passwordStorageKey != null) {
                this.secureStorageProvider.removeFromSecureStorage(this.passwordStorageKey);
            }
        }
        catch (Exception e) {
            DqpPlugin.Util.log((Throwable)e);
        }
        if (currentPassword != null) {
            this.setPassword(currentPassword);
        }
    }

    public String getPassword() {
        String password = this.retrievePassword();
        return password;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public abstract String getType();

    protected void generateUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isSecure() ? "mms://" : "mm://");
        sb.append(this.getHost());
        sb.append(':');
        sb.append(this.getPort());
        this.url = sb.toString();
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.getHost(), this.getPort(), this.isSecure(), this.getUsername()});
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setAll(ITeiidConnectionInfo info) {
        this.settingAllInfo = true;
        this.setHost(info.getHost());
        this.setPort(info.getPort());
        this.setUsername(info.getUsername());
        this.setSecure(info.isSecure());
        this.settingAllInfo = false;
        this.setPassword(info.getPassword());
    }

    public void setAll(String host, String port, String username, String password, boolean isSecure) {
        this.settingAllInfo = true;
        this.setHost(host);
        this.setPort(port);
        this.setUsername(username);
        this.setSecure(isSecure);
        this.settingAllInfo = false;
        this.setPassword(password);
    }

    public String getPassToken() {
        return this.passToken;
    }

    public void setPassword(String password) {
        if (this.settingAllInfo) {
            return;
        }
        this.url = null;
        this.passToken = null;
        this.passwordStorageKey = null;
        if (password != null) {
            this.storePassword(password);
        }
    }

    public void setHost(String host) {
        this.host = host;
        this.resetPassword();
    }

    public void setPort(String port) {
        this.port = port;
        try {
            this.portNumber = Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {
            this.portNumber = 0;
        }
        this.resetPassword();
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
        this.resetPassword();
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String toString() {
        return DqpPlugin.Util.getString("teiidConnectionInfoProperties", new Object[]{this.getType(), this.getHost(), this.getPort(), this.getUsername(), this.getPassword(), this.isSecure()});
    }

    public IStatus validate() {
        IStatus status = this.validateUrl();
        if (!status.isOK()) {
            return status;
        }
        return this.validateUsername();
    }

    protected IStatus validateUrl() {
        try {
            TeiidServerUtils.validateServerUrl(this.getUrl());
        }
        catch (MalformedURLException e) {
            return new Status(4, "org.teiid.designer.dqp", DqpPlugin.Util.getString("invalidServerUrl", new Object[]{this.getType(), e.getMessage()}), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    protected IStatus validateUsername() {
        if (StringUtilities.isEmpty((String)this.username)) {
            return new Status(4, "org.teiid.designer.dqp", DqpPlugin.Util.getString("connectionUsernameIsEmpty", (Object)this.getType()));
        }
        return Status.OK_STATUS;
    }
}

