/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.datatools.connectivity.spi.ISecureStorageProvider;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.TeiidConnectionInfo;
import org.teiid.designer.runtime.TeiidServerUtils;
import org.teiid.designer.runtime.spi.ITeiidJdbcInfo;

public class TeiidJdbcInfo
extends TeiidConnectionInfo
implements ITeiidJdbcInfo {
    private static final String VDB_PLACEHOLDER = "<vdbname>";
    private static final String JDBC_TEIID_PREFIX = "jdbc:teiid:";
    private String vdbname;

    public TeiidJdbcInfo(String host, String port, String username, ISecureStorageProvider secureStorageProvider, String password, boolean secure) {
        this(VDB_PLACEHOLDER, host, port, username, secureStorageProvider, password, secure);
    }

    private TeiidJdbcInfo(String vdbname, String host, String port, String username, ISecureStorageProvider secureStorageProvider, String password, boolean secure) {
        super(host, port, username, secureStorageProvider, password, secure);
        CoreArgCheck.isNotEmpty((String)vdbname, (String)"vdbname");
        this.vdbname = vdbname;
        if (password != null) {
            this.setPassword(password);
        }
    }

    public TeiidJdbcInfo(String vdbname, ITeiidJdbcInfo teiidJdbcInfo) {
        this(vdbname, teiidJdbcInfo.getHost(), teiidJdbcInfo.getPort(), teiidJdbcInfo.getUsername(), teiidJdbcInfo.getSecureStorageProvider(), teiidJdbcInfo.getPassword(), teiidJdbcInfo.isSecure());
    }

    @Override
    protected String getPasswordKey() {
        return "jdbc_password";
    }

    public ITeiidJdbcInfo clone() {
        TeiidJdbcInfo cloned = new TeiidJdbcInfo(this.getHost(), this.getPort(), this.getUsername(), this.getSecureStorageProvider(), this.getPassword(), this.isSecure());
        return cloned;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.vdbname.equals(((TeiidJdbcInfo)object).vdbname);
    }

    @Override
    public String getType() {
        return DqpPlugin.Util.getString("jdbcInfoType", new Object[0]);
    }

    @Override
    protected void generateUrl() {
        super.generateUrl();
        String superURL = super.getUrl();
        StringBuilder sb = new StringBuilder();
        sb.append(JDBC_TEIID_PREFIX);
        sb.append(this.vdbname);
        sb.append('@');
        this.url = sb.append(superURL).toString();
    }

    @Override
    public int hashCode() {
        return HashCodeUtil.hashCode((int)super.hashCode(), (Object[])new Object[]{this.vdbname});
    }

    @Override
    public String toString() {
        return DqpPlugin.Util.getString("jdbcConnectionInfoProperties", new Object[]{super.toString(), this.vdbname});
    }

    @Override
    protected IStatus validateUrl() {
        try {
            TeiidServerUtils.validPortNumber(this.getPort());
        }
        catch (Exception e) {
            return new Status(4, "org.teiid.designer.dqp", DqpPlugin.Util.getString("invalidServerUrl", new Object[]{this.getType(), e.getMessage()}), (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

