/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidServerManager;

public final class TeiidJdbcPortManager {
    private Map<String, String> overrideMap;
    private Map<String, String> defaultsMap;

    public TeiidJdbcPortManager() {
        this.init();
    }

    private void init() {
        this.overrideMap = new HashMap<String, String>(10);
        this.defaultsMap = new HashMap<String, String>(10);
    }

    public void setPort(ITeiidServer server, int port, boolean isOverride) {
        if (isOverride) {
            if (port < 1) {
                this.overrideMap.remove(server);
            } else {
                this.overrideMap.put(server.getId(), Integer.toString(port));
            }
        } else if (port < 1) {
            this.defaultsMap.remove(server);
        } else {
            this.defaultsMap.put(server.getId(), Integer.toString(port));
        }
    }

    public String getPort(ITeiidServer server, boolean isOverride) {
        if (isOverride) {
            return this.overrideMap.get(server.getId());
        }
        return this.defaultsMap.get(server.getId());
    }

    public void cleanPorts(ITeiidServerManager manager) {
        ArrayList<String> serverIDs = new ArrayList<String>(10);
        for (ITeiidServer server : manager.getServers()) {
            serverIDs.add(server.getId());
        }
        ArrayList<String> staleOverrideServerIDs = new ArrayList<String>(10);
        for (String serverID : this.overrideMap.keySet()) {
            if (serverIDs.contains(serverID)) continue;
            staleOverrideServerIDs.add(serverID);
        }
        for (String staleID : staleOverrideServerIDs) {
            this.overrideMap.remove(staleID);
        }
    }
}

