/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.wst.server.core.IServer;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.TeiidAdminInfo;
import org.teiid.designer.runtime.TeiidJdbcInfo;
import org.teiid.designer.runtime.TeiidServer;
import org.teiid.designer.runtime.TeiidServerManager;
import org.teiid.designer.runtime.spi.EventManager;
import org.teiid.designer.runtime.spi.ITeiidAdminInfo;
import org.teiid.designer.runtime.spi.ITeiidJdbcInfo;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidServerManager;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;

public class TeiidServerFactory {
    private void processOptions(ITeiidServer teiidServer, ITeiidServerManager serverManager, ServerOptions[] options) {
        List<Object> optionList = Collections.emptyList();
        if (options != null) {
            optionList = Arrays.asList(options);
        }
        if (optionList.contains((Object)ServerOptions.ADMIN_SECURE_CONNECTION)) {
            teiidServer.getTeiidAdminInfo().setSecure(true);
        }
        if (optionList.contains((Object)ServerOptions.JDBC_SECURE_CONNECTION)) {
            teiidServer.getTeiidJdbcInfo().setSecure(true);
        }
        if (optionList.contains((Object)ServerOptions.CONNECT)) {
            try {
                teiidServer.connect();
            }
            catch (Exception ex) {
                DqpPlugin.Util.log((Throwable)ex);
            }
        }
        if (optionList.contains((Object)ServerOptions.ADD_TO_REGISTRY)) {
            serverManager.addServer(teiidServer);
        }
    }

    public ITeiidServer createTeiidServer(ITeiidServerVersion serverVersion, ITeiidServerManager serverManager, IServer parentServer, String adminPort, String adminUserName, String adminPassword, String jdbcPort, String jdbcUserName, String jdbcPassword, ServerOptions ... options) {
        String adminPWD = adminPassword;
        String jdbcPWD = jdbcPassword;
        String host = parentServer.getHost();
        if (host == null) {
            host = "localhost";
        }
        TeiidAdminInfo teiidAdminInfo = new TeiidAdminInfo(host, adminPort, adminUserName, serverManager.getSecureStorageProvider(), adminPWD, false);
        TeiidJdbcInfo teiidJdbcInfo = new TeiidJdbcInfo(host, jdbcPort, jdbcUserName, serverManager.getSecureStorageProvider(), jdbcPWD, false);
        TeiidServer teiidServer = new TeiidServer(serverVersion, host, teiidAdminInfo, teiidJdbcInfo, (EventManager)serverManager, parentServer, false);
        this.processOptions(teiidServer, serverManager, options);
        return teiidServer;
    }

    public ITeiidServer createTeiidServer(ITeiidServerVersion serverVersion, String host, ITeiidAdminInfo teiidAdminInfo, ITeiidJdbcInfo teiidJdbcInfo, TeiidServerManager serverManager, IServer parentServer, ServerOptions ... options) {
        TeiidServer teiidServer = new TeiidServer(serverVersion, host, teiidAdminInfo, teiidJdbcInfo, (EventManager)serverManager, parentServer);
        this.processOptions(teiidServer, serverManager, options);
        return teiidServer;
    }

    public static enum ServerOptions {
        ADD_TO_REGISTRY,
        CONNECT,
        NO_CHECK_SERVER_REGISTRY,
        NO_CHECK_CONNECTION,
        ADMIN_SECURE_CONNECTION,
        JDBC_SECURE_CONNECTION;

    }
}

