/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime;

import java.io.File;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.wst.server.core.IServer;
import org.teiid.core.designer.util.Base64;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.datatools.connectivity.spi.ISecureStorageProvider;
import org.teiid.designer.core.util.KeyInValueHashMap;
import org.teiid.designer.runtime.IServersProvider;
import org.teiid.designer.runtime.OrphanedTeiidServerException;
import org.teiid.designer.runtime.TeiidAdminInfo;
import org.teiid.designer.runtime.TeiidJdbcInfo;
import org.teiid.designer.runtime.TeiidServerFactory;
import org.teiid.designer.runtime.TeiidServerManager;
import org.teiid.designer.runtime.TeiidServerRegistryConstants;
import org.teiid.designer.runtime.spi.ITeiidAdminInfo;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TeiidServerRegistryReader
implements TeiidServerRegistryConstants {
    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    DocumentBuilder docBuilder;
    Document doc;
    Element root;
    ITeiidServer defaultServer;
    TeiidServerManager teiidServerManager;
    ISecureStorageProvider secureStorageProvider;
    boolean doDebug;
    private IServersProvider parentServersProvider;
    private final KeyInValueHashMap<String, ITeiidServer> teiidServers;

    public TeiidServerRegistryReader(TeiidServerManager teiidServerManager, IServersProvider parentServersProvider, ISecureStorageProvider secureStorageProvider, boolean doDebug) {
        this.teiidServerManager = teiidServerManager;
        this.parentServersProvider = parentServersProvider;
        this.secureStorageProvider = secureStorageProvider;
        this.doDebug = doDebug;
        this.teiidServers = new KeyInValueHashMap((KeyInValueHashMap.KeyFromValueAdapter)new TeiidServerKeyValueAdapter());
    }

    public Collection<ITeiidServer> restoreServers() throws Exception {
        this.factory = DocumentBuilderFactory.newInstance();
        this.docBuilder = this.factory.newDocumentBuilder();
        this.doc = this.docBuilder.parse(new File(this.teiidServerManager.getStateFileName()));
        Element root = this.doc.getDocumentElement();
        NodeList servers = root.getChildNodes();
        int size = servers.getLength();
        int i = 0;
        while (i < size) {
            Node serverNode = servers.item(i);
            ITeiidServer teiidServer = this.loadServer(serverNode);
            if (teiidServer != null) {
                this.teiidServers.add((Object)teiidServer);
            }
            ++i;
        }
        return this.teiidServers.values();
    }

    private ITeiidServer loadServer(Node serverNode) throws Exception {
        NodeList connectionNodes;
        Node defaultServerNode;
        Node customLabelNode;
        Node parentServerNode;
        TeiidAdminInfo teiidAdminInfo = null;
        TeiidJdbcInfo teiidJdbcInfo = null;
        String jdbcOverridePort = null;
        NamedNodeMap serverAttributeMap = serverNode.getAttributes();
        if (serverAttributeMap == null) {
            return null;
        }
        String host = null;
        String parentServerId = null;
        String customLabel = null;
        boolean previewServer = false;
        if (this.doDebug) {
            System.out.println("  <<< LOADING SERVER INFO");
        }
        ITeiidServerVersion teiidServerVersion = TeiidServerVersion.Version.TEIID_DEFAULT.get();
        Node versionNode = serverAttributeMap.getNamedItem("version");
        if (versionNode != null) {
            teiidServerVersion = new TeiidServerVersion(versionNode.getNodeValue());
        }
        this.attributeRead("version", teiidServerVersion.toString());
        Node hostNode = serverAttributeMap.getNamedItem("host");
        if (hostNode != null) {
            host = hostNode.getNodeValue();
            this.attributeRead("host", host);
        }
        if ((parentServerNode = serverAttributeMap.getNamedItem("parentServerId")) != null) {
            parentServerId = parentServerNode.getNodeValue();
            this.attributeRead("parentServerId", parentServerId);
        }
        if ((customLabelNode = serverAttributeMap.getNamedItem("customLabel")) != null) {
            customLabel = customLabelNode.getNodeValue();
            this.attributeRead("customLabel", customLabel);
        }
        if ((defaultServerNode = serverAttributeMap.getNamedItem("default")) != null) {
            previewServer = Boolean.parseBoolean(defaultServerNode.getNodeValue());
            this.attributeRead("default", defaultServerNode.getNodeValue());
        }
        if ((connectionNodes = serverNode.getChildNodes()).getLength() > 0) {
            int connSize = connectionNodes.getLength();
            int j = 0;
            while (j < connSize) {
                Node connNode = connectionNodes.item(j);
                if (connNode.getNodeType() != 3) {
                    NamedNodeMap attributeMap;
                    if (connNode.getNodeName().equalsIgnoreCase("admin")) {
                        if (this.doDebug) {
                            System.out.println("     <<<   ADMIN INFO");
                        }
                        if ((attributeMap = connNode.getAttributes()) != null) {
                            Node adminSecureNode;
                            if (host == null) {
                                Node adminHostNode = attributeMap.getNamedItem("host");
                                assert (adminHostNode != null);
                                host = adminHostNode.getNodeValue();
                                this.attributeRead("host", host);
                            }
                            Node adminPortNode = attributeMap.getNamedItem("port");
                            assert (adminPortNode != null);
                            String adminPort = adminPortNode.getNodeValue();
                            this.attributeRead("port", adminPort);
                            Node userNode = attributeMap.getNamedItem("user");
                            assert (userNode != null);
                            String adminUsername = userNode.getNodeValue();
                            this.attributeRead("user", adminUsername);
                            Node passwordNode = attributeMap.getNamedItem("password");
                            String adminPassword = null;
                            if (passwordNode != null) {
                                adminPassword = new String(Base64.decode((CharSequence)passwordNode.getNodeValue()), "UTF-8");
                                this.attributeRead("password", adminPassword);
                            }
                            String adminSecureStr = (adminSecureNode = attributeMap.getNamedItem("secure")) == null ? Boolean.FALSE.toString() : adminSecureNode.getNodeValue();
                            this.attributeRead("secure", adminSecureStr);
                            teiidAdminInfo = new TeiidAdminInfo(host, adminPort, adminUsername, this.secureStorageProvider, adminPassword, Boolean.parseBoolean(adminSecureStr));
                        }
                    } else if (connNode.getNodeName().equalsIgnoreCase("jdbc")) {
                        if (this.doDebug) {
                            System.out.println("     <<<   JDBC INFO");
                        }
                        if ((attributeMap = connNode.getAttributes()) != null) {
                            Node jdbcSecureNode;
                            if (host == null) {
                                Node jdbcHostNode = attributeMap.getNamedItem("jdbchost");
                                assert (jdbcHostNode != null);
                                host = jdbcHostNode.getNodeValue();
                                this.attributeRead("jdbchost", host);
                            }
                            Node jdbcPortNode = attributeMap.getNamedItem("jdbcport");
                            assert (jdbcPortNode != null);
                            String jdbcPort = jdbcPortNode.getNodeValue();
                            Node jdbcPortOverrideNode = attributeMap.getNamedItem("jdbcportoverride");
                            if (jdbcPortOverrideNode != null) {
                                jdbcOverridePort = jdbcPortOverrideNode.getNodeValue();
                                this.attributeRead("jdbcportoverride", jdbcOverridePort);
                            }
                            Node jdbcUserNode = attributeMap.getNamedItem("jdbcuser");
                            assert (jdbcUserNode != null);
                            String jdbcUsername = jdbcUserNode.getNodeValue();
                            this.attributeRead("jdbcuser", jdbcUsername);
                            Node jdbcPasswordNode = attributeMap.getNamedItem("jdbcpassword");
                            String jdbcPassword = null;
                            if (jdbcPasswordNode != null) {
                                jdbcPassword = new String(Base64.decode((CharSequence)jdbcPasswordNode.getNodeValue()), "UTF-8");
                                this.attributeRead("jdbcpassword", jdbcPassword);
                            }
                            String jdbcSecureStr = (jdbcSecureNode = attributeMap.getNamedItem("jdbcsecure")) == null ? Boolean.FALSE.toString() : jdbcSecureNode.getNodeValue();
                            this.attributeRead("jdbcsecure", jdbcSecureStr);
                            teiidJdbcInfo = new TeiidJdbcInfo(host, jdbcPort, jdbcUsername, this.secureStorageProvider, jdbcPassword, Boolean.parseBoolean(jdbcSecureStr));
                        }
                    }
                }
                ++j;
            }
        }
        IServer parentServer = null;
        try {
            parentServer = this.findParentServer(host, parentServerId, teiidAdminInfo);
        }
        catch (OrphanedTeiidServerException orphanedTeiidServerException) {
            return null;
        }
        TeiidServerFactory teiidServerFactory = new TeiidServerFactory();
        ITeiidServer teiidServer = teiidServerFactory.createTeiidServer(teiidServerVersion, host, teiidAdminInfo, teiidJdbcInfo, this.teiidServerManager, parentServer, new TeiidServerFactory.ServerOptions[0]);
        teiidServer.setCustomLabel(customLabel);
        if (!StringUtilities.isEmpty(jdbcOverridePort)) {
            this.teiidServerManager.getJdbcPortManager().setPort(teiidServer, Integer.parseInt(jdbcOverridePort), true);
        }
        if (previewServer) {
            this.defaultServer = teiidServer;
        }
        return teiidServer;
    }

    private IServer findParentServer(String host, String parentServerId, ITeiidAdminInfo teiidAdminInfo) throws OrphanedTeiidServerException {
        IServer[] servers;
        IServer[] iServerArray = servers = this.parentServersProvider.getServers();
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (host.equals(server.getHost()) && (parentServerId == null || server.getId().equals(parentServerId))) {
                return server;
            }
            ++n2;
        }
        throw new OrphanedTeiidServerException(teiidAdminInfo);
    }

    private void attributeRead(String key, String value) {
        if (this.doDebug) {
            System.out.println("             Read Server Attribute = " + key + "  value = " + value);
        }
    }

    public ITeiidServer getDefaultServer() {
        return this.defaultServer;
    }

    private class TeiidServerKeyValueAdapter
    implements KeyInValueHashMap.KeyFromValueAdapter<String, ITeiidServer> {
        private TeiidServerKeyValueAdapter() {
        }

        public String getKey(ITeiidServer value) {
            return value.getId();
        }
    }
}

