/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime;

import java.io.FileOutputStream;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.util.Base64;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.TeiidServerManager;
import org.teiid.designer.runtime.TeiidServerRegistryConstants;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TeiidServerRegistryWriter
implements TeiidServerRegistryConstants {
    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    DocumentBuilder docBuilder;
    Document doc;
    Element root;
    TeiidServerManager teiidServerManager;
    ITeiidServer defaultServer;
    boolean doDebug;

    public TeiidServerRegistryWriter(TeiidServerManager teiidServerManager, ITeiidServer defaultServer, boolean doDebug) {
        this.teiidServerManager = teiidServerManager;
        this.defaultServer = defaultServer;
        this.doDebug = doDebug;
    }

    public void storeServers(Collection<ITeiidServer> teiidServers) throws TransformerFactoryConfigurationError {
        try {
            this.docBuilder = this.factory.newDocumentBuilder();
            this.doc = this.docBuilder.newDocument();
            this.root = this.doc.createElement("servers");
            this.doc.appendChild(this.root);
            Collection<ITeiidServer> servers = teiidServers;
            for (ITeiidServer teiidServer : servers) {
                this.storeServer(teiidServer);
            }
            DOMSource source = new DOMSource(this.doc);
            StreamResult resultXML = new StreamResult(new FileOutputStream(this.teiidServerManager.getStateFileName()));
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(source, resultXML);
        }
        catch (Exception exception) {
            Status status = new Status(4, "org.teiid.designer.dqp", DqpPlugin.Util.getString("errorSavingServerRegistry", (Object)this.teiidServerManager.getStateFileName()));
            DqpPlugin.Util.log((IStatus)status);
        }
    }

    private void storeServer(ITeiidServer teiidServer) throws Exception {
        Element serverElement = this.doc.createElement("server");
        this.root.appendChild(serverElement);
        if (this.doDebug) {
            System.out.println("  >>> SAVING SERVER INFO");
        }
        this.setAttribute(serverElement, "version", teiidServer.getServerVersion().toString());
        this.setAttribute(serverElement, "host", teiidServer.getHost());
        this.setAttribute(serverElement, "parentServerId", teiidServer.getParent().getId());
        if (!StringUtilities.isEmpty((String)teiidServer.getCustomLabel())) {
            this.setAttribute(serverElement, "customLabel", teiidServer.getCustomLabel());
        }
        this.storeTeiidAdminInfo(teiidServer, serverElement);
        this.storeTeiidJdbcInfo(teiidServer, serverElement);
        if (this.defaultServer != null && this.defaultServer.equals(teiidServer)) {
            serverElement.setAttribute("default", Boolean.toString(true));
        }
    }

    private void storeTeiidAdminInfo(ITeiidServer teiidServer, Element serverElement) throws Exception {
        Element adminElement = this.doc.createElement("admin");
        serverElement.appendChild(adminElement);
        if (this.doDebug) {
            System.out.println("          ADMIN INFO");
        }
        this.setAttribute(adminElement, "port", teiidServer.getTeiidAdminInfo().getPort());
        this.setAttribute(adminElement, "user", teiidServer.getTeiidAdminInfo().getUsername());
        String passToken = teiidServer.getTeiidAdminInfo().getPassToken();
        if (passToken != null) {
            this.setAttribute(adminElement, "password", Base64.encodeBytes((byte[])passToken.getBytes("UTF-8")));
        }
        this.setAttribute(adminElement, "secure", Boolean.toString(teiidServer.getTeiidAdminInfo().isSecure()));
    }

    private void storeTeiidJdbcInfo(ITeiidServer teiidServer, Element serverElement) throws Exception {
        String actualPort;
        Element jdbcElement = this.doc.createElement("jdbc");
        serverElement.appendChild(jdbcElement);
        if (this.doDebug) {
            System.out.println("          JDBC INFO");
        }
        if ((actualPort = this.teiidServerManager.getJdbcPortManager().getPort(teiidServer, false)) == null) {
            actualPort = "31000";
        }
        this.setAttribute(jdbcElement, "jdbcport", actualPort);
        String overridePort = this.teiidServerManager.getJdbcPortManager().getPort(teiidServer, true);
        if (overridePort != null) {
            this.setAttribute(jdbcElement, "jdbcportoverride", overridePort);
        }
        this.setAttribute(jdbcElement, "jdbcuser", teiidServer.getTeiidJdbcInfo().getUsername());
        String passToken = teiidServer.getTeiidJdbcInfo().getPassToken();
        if (passToken != null) {
            this.setAttribute(jdbcElement, "jdbcpassword", Base64.encodeBytes((byte[])passToken.getBytes("UTF-8")));
        }
        this.setAttribute(jdbcElement, "jdbcsecure", Boolean.toString(teiidServer.getTeiidJdbcInfo().isSecure()));
    }

    private void setAttribute(Element element, String key, String value) {
        element.setAttribute(key, value);
        if (this.doDebug) {
            System.out.println("             Set  Server Attribute = " + key + "  value = " + value);
        }
    }
}

