/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.teiid.designer.runtime.DqpPlugin;

public class TeiidURL {
    private static final String NON_SECURE_PROTOCOL = "mm";
    private static final String SECURE_PROTOCOL = "mms";
    private static final String DOUBLE_SLASH_DELIMITER = "//";
    private static final String COMMA_DELIMITER = ",";
    private static final String COLON_DELIMITER = ":";
    private static final String DEFAULT_PREFIX = "mm://";
    private static final String SECURE_PREFIX = "mms://";
    private static final String INVALID_FORMAT_SERVER = DqpPlugin.Util.getString("TeiidURL.Invalid_format", new Object[0]);
    private String appServerURL;
    private List<HostInfo> hosts = new ArrayList<HostInfo>();
    private boolean usingSSL = false;

    public TeiidURL(String serverURL) throws MalformedURLException {
        if (serverURL == null) {
            throw new MalformedURLException(INVALID_FORMAT_SERVER);
        }
        if (serverURL.toLowerCase().startsWith(SECURE_PREFIX)) {
            this.usingSSL = true;
        } else if (!serverURL.toLowerCase().startsWith(DEFAULT_PREFIX)) {
            throw new MalformedURLException(INVALID_FORMAT_SERVER);
        }
        this.appServerURL = serverURL;
        this.parseServerURL(serverURL.substring(this.usingSSL ? SECURE_PREFIX.length() : DEFAULT_PREFIX.length()), INVALID_FORMAT_SERVER);
    }

    public TeiidURL(String host, int port, boolean secure) {
        this.usingSSL = secure;
        if (host.startsWith("[")) {
            host = host.substring(1, host.indexOf(93));
        }
        this.hosts.add(new HostInfo(host, port));
    }

    public static boolean isValidServerURL(String serverURL) {
        boolean valid = true;
        try {
            new TeiidURL(serverURL);
        }
        catch (Exception exception) {
            valid = false;
        }
        return valid;
    }

    public String getHosts() {
        StringBuffer hostList = new StringBuffer("");
        if (this.hosts != null) {
            Iterator<HostInfo> iterator = this.hosts.iterator();
            while (iterator.hasNext()) {
                HostInfo element = iterator.next();
                hostList.append(element.getHostName());
                if (!iterator.hasNext()) continue;
                hostList.append(COMMA_DELIMITER);
            }
        }
        return hostList.toString();
    }

    public String getPorts() {
        StringBuffer portList = new StringBuffer("");
        if (this.hosts != null) {
            Iterator<HostInfo> iterator = this.hosts.iterator();
            while (iterator.hasNext()) {
                HostInfo element = iterator.next();
                portList.append(element.getPortNumber());
                if (!iterator.hasNext()) continue;
                portList.append(COMMA_DELIMITER);
            }
        }
        return portList.toString();
    }

    /*
     * Unable to fully structure code
     */
    private void parseServerURL(String serverURL, String exceptionMessage) throws MalformedURLException {
        st = new StringTokenizer(serverURL, ",");
        if (st.hasMoreTokens()) ** GOTO lbl28
        throw new MalformedURLException(exceptionMessage);
lbl-1000:
        // 1 sources

        {
            nextToken = st.nextToken();
            nextToken = nextToken.trim();
            host = "";
            port = "";
            if (nextToken.startsWith("[")) {
                hostEnd = nextToken.indexOf("]:");
                if (hostEnd == -1) {
                    throw new MalformedURLException(DqpPlugin.Util.getString("TeiidURL.invalid_ipv6_hostport", new Object[]{nextToken, exceptionMessage}));
                }
                host = nextToken.substring(1, hostEnd);
                port = nextToken.substring(hostEnd + 2);
            } else {
                hostEnd = nextToken.indexOf(":");
                if (hostEnd == -1) {
                    throw new MalformedURLException(DqpPlugin.Util.getString("TeiidURL.invalid_hostport", new Object[]{nextToken, exceptionMessage}));
                }
                host = nextToken.substring(0, hostEnd);
                port = nextToken.substring(hostEnd + 1);
            }
            host = host.trim();
            port = port.trim();
            if (host.equals("") || port.equals("")) {
                throw new MalformedURLException(DqpPlugin.Util.getString("TeiidURL.invalid_hostport", new Object[]{nextToken, exceptionMessage}));
            }
            portNumber = this.validatePort(port);
            hostInfo = new HostInfo(host, portNumber);
            this.hosts.add(hostInfo);
lbl28:
            // 2 sources

            ** while (st.hasMoreTokens())
        }
lbl29:
        // 1 sources

    }

    private int validatePort(String port) throws MalformedURLException {
        int portNumber;
        try {
            portNumber = Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedURLException(DqpPlugin.Util.getString("TeiidURL.non_numeric_port", (Object)port));
        }
        if (portNumber < 0 || portNumber > 65535) {
            String msg = DqpPlugin.Util.getString("TeiidURL.port_out_of_range", (Object)portNumber);
            throw new MalformedURLException(msg);
        }
        return portNumber;
    }

    public String getAppServerURL() {
        if (this.appServerURL == null) {
            StringBuffer sb = new StringBuffer();
            if (this.usingSSL) {
                sb.append(SECURE_PREFIX);
            } else {
                sb.append(DEFAULT_PREFIX);
            }
            Iterator<HostInfo> iter = this.hosts.iterator();
            while (iter.hasNext()) {
                boolean ipv6HostName;
                HostInfo host = iter.next();
                boolean bl = ipv6HostName = host.getHostName().indexOf(58) != -1;
                if (ipv6HostName) {
                    sb.append('[');
                }
                sb.append(host.getHostName());
                if (ipv6HostName) {
                    sb.append(']');
                }
                sb.append(COLON_DELIMITER);
                sb.append(host.getPortNumber());
                if (!iter.hasNext()) continue;
                sb.append(COMMA_DELIMITER);
            }
            this.appServerURL = sb.toString();
        }
        return this.appServerURL;
    }

    public String toString() {
        return this.getAppServerURL();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TeiidURL)) {
            return false;
        }
        TeiidURL url = (TeiidURL)obj;
        return this.appServerURL.equals(url.getAppServerURL());
    }

    public int hashCode() {
        return this.appServerURL.hashCode();
    }

    public boolean isUsingSSL() {
        return this.usingSSL;
    }

    private class HostInfo {
        private String host;
        private int port;

        public HostInfo(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String getHostName() {
            return this.host;
        }

        public int getPortNumber() {
            return this.port;
        }
    }
}

