/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidTranslator;
import org.teiid.designer.runtime.spi.TeiidPropertyDefinition;

public class TranslatorTemplate
implements ITeiidTranslator {
    private final Properties changedProperties;
    private ITeiidTranslator translator;

    public TranslatorTemplate(ITeiidTranslator translator) {
        CoreArgCheck.isNotNull((Object)translator, (String)"translator");
        this.translator = translator;
        this.changedProperties = new Properties();
    }

    public Properties getChangedProperties() {
        return this.changedProperties;
    }

    public String getPropertyValue(String name, ITeiidTranslator.TranslatorPropertyType type) {
        if (this.changedProperties.containsKey(name)) {
            return this.changedProperties.getProperty(name);
        }
        return this.translator.getPropertyValue(name, type);
    }

    public Properties getDefaultPropertyValues() {
        return this.translator.getDefaultPropertyValues();
    }

    public String isValidPropertyValue(String name, String value, ITeiidTranslator.TranslatorPropertyType type) {
        return this.translator.isValidPropertyValue(name, value, type);
    }

    public Properties getProperties() {
        Properties props = new Properties(this.translator.getProperties());
        props.putAll((Map<?, ?>)this.changedProperties);
        return props;
    }

    public void setProperties(Properties changedProperties) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void setPropertyValue(String name, String value, ITeiidTranslator.TranslatorPropertyType type) throws Exception {
        if (this.isValidPropertyValue(name, value, type) != null) {
            throw new Exception(DqpPlugin.Util.getString("invalidPropertyValue", new Object[]{value, name}));
        }
        this.changedProperties.setProperty(name, value);
    }

    public Collection<String> findInvalidProperties(ITeiidTranslator.TranslatorPropertyType type) {
        return this.translator.findInvalidProperties(type);
    }

    public String getName() {
        return this.translator.getName();
    }

    public String getType() {
        return this.translator.getType();
    }

    public ITeiidServer getTeiidServer() {
        return this.translator.getTeiidServer();
    }

    public TeiidPropertyDefinition getPropertyDefinition(String name, ITeiidTranslator.TranslatorPropertyType type) {
        return this.translator.getPropertyDefinition(name, type);
    }

    public Collection<TeiidPropertyDefinition> getPropertyDefinitions() {
        return this.translator.getPropertyDefinitions();
    }

    public Collection<TeiidPropertyDefinition> getImportPropertyDefinitions() {
        return this.translator.getImportPropertyDefinitions();
    }

    public Collection<TeiidPropertyDefinition> getExtensionPropertyDefinitions() {
        return this.translator.getExtensionPropertyDefinitions();
    }
}

