/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.adapter;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.jboss.dmr.ModelNode;
import org.jboss.ide.eclipse.as.core.server.internal.v7.JBoss7Server;
import org.jboss.ide.eclipse.as.core.server.v7.management.AS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IAS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManagerUtil;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.adapter.JBossServerUtil;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;

public abstract class JBoss7ServerUtil
extends JBossServerUtil {
    private static final String OP = "operation";
    private static final String NAME = "name";
    private static final String READ_ATTRIBUTE_OPERATION = "read-attribute";
    private static final String READ_CHILDREN_NAMES_OPERATION = "read-children-names";
    private static final String SUBSYSTEM = "subsystem";
    private static final String CHILD_TYPE = "child-type";
    private static final String SOCKET_BINDING_GROUP = "socket-binding-group";
    private static final String SOCKET_BINDING = "socket-binding";
    private static final String OP_ADDR = "address";
    private static final String PORT = "port";

    private static ModelNode executeRequest(IServer parentServer, JBoss7Server jboss7Server, ModelNode request) throws Exception {
        String requestString = request.toJSONString(true);
        int timeout = DqpPlugin.getInstance().getJbossRequestTimeout();
        HashMap<String, Integer> props = new HashMap<String, Integer>();
        props.put("PROPERTY_TIMEOUT", timeout);
        String resultString = JBoss7ManagerUtil.getService((IServer)parentServer).execute((IAS7ManagementDetails)new AS7ManagementDetails(parentServer, props), requestString);
        return ModelNode.fromJSONString((String)resultString);
    }

    protected static boolean isHostConnected(String host, int port) throws Exception {
        Socket socket = null;
        Reader in = null;
        InetSocketAddress endPoint = new InetSocketAddress(host, port);
        if (endPoint.isUnresolved()) {
            DqpPlugin.Util.log(2, DqpPlugin.Util.getString("jbossServerConnectionFailureMessage", (Object)endPoint));
            return false;
        }
        try {
            socket = new Socket();
            socket.connect(endPoint, 1024);
            InputStream socketReader = socket.getInputStream();
            char[] buffer = new char[100];
            in = new InputStreamReader(socketReader);
            int rsz = in.read(buffer, 0, buffer.length);
            if (rsz == -1) {
                if (DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/jboss/connection")) {
                    String message = DqpPlugin.Util.getString("jbossServerConnectionStreamEmpty", new Object[]{host, port});
                    Status status = new Status(0, "org.teiid.designer.dqp", message);
                    DqpPlugin.Util.log((IStatus)status);
                }
                return false;
            }
            StringBuffer output = new StringBuffer();
            int i = 0;
            while (i < buffer.length) {
                if (Character.isLetterOrDigit(buffer[i])) {
                    output.append(buffer[i]);
                }
                ++i;
            }
            if (DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/jboss/connection")) {
                String message = DqpPlugin.Util.getString("jbossServerHeartBeat", new Object[]{host, port, output});
                Status status = new Status(0, "org.teiid.designer.dqp", message);
                DqpPlugin.Util.log((IStatus)status);
            }
            return true;
        }
        catch (Exception ex) {
            if (DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/jboss/connection")) {
                DqpPlugin.Util.log((Throwable)ex);
            }
            return false;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (socket != null && socket.isConnected()) {
                    socket.close();
                    socket = null;
                }
            }
            catch (Exception ex2) {
                DqpPlugin.Util.log((Throwable)ex2);
            }
        }
    }

    public static boolean isJBossServerConnected(IServer parentServer, JBoss7Server jboss7Server) throws Exception {
        if (!JBoss7ServerUtil.serverStarted(jboss7Server.getServer())) {
            return false;
        }
        String host = jboss7Server.getHost();
        int port = jboss7Server.getManagementPort();
        return JBoss7ServerUtil.isHostConnected(host, port);
    }

    public static boolean isTeiidServer(IServer parentServer, JBoss7Server jboss7Server) throws Exception {
        if (!JBoss7ServerUtil.serverStarted(parentServer)) {
            return false;
        }
        ModelNode request = new ModelNode();
        request.get(OP).set(READ_CHILDREN_NAMES_OPERATION);
        request.get(CHILD_TYPE).set(SUBSYSTEM);
        ModelNode result = JBoss7ServerUtil.executeRequest(parentServer, jboss7Server, request);
        List subsystems = result.asList();
        for (ModelNode subsystem : subsystems) {
            if (!subsystem.asString().equals("teiid")) continue;
            return true;
        }
        return false;
    }

    public static String getJdbcPort(IServer parentServer, JBoss7Server jboss7Server) throws Exception {
        if (!JBoss7ServerUtil.serverStarted(parentServer)) {
            return "31000";
        }
        ModelNode request = new ModelNode();
        request.get(OP).set(READ_ATTRIBUTE_OPERATION);
        ModelNode address = new ModelNode();
        address.add(SOCKET_BINDING_GROUP, "standard-sockets");
        address.add(SOCKET_BINDING, "teiid-jdbc");
        request.get(OP_ADDR).set(address);
        request.get(NAME).set(PORT);
        ModelNode result = JBoss7ServerUtil.executeRequest(parentServer, jboss7Server, request);
        return result.asString();
    }

    public static ITeiidServerVersion getTeiidRuntimeVersion(IServer parentServer, JBoss7Server jboss7Server) throws Exception {
        if (!JBoss7ServerUtil.serverStarted(parentServer)) {
            return TeiidServerVersion.Version.TEIID_8_6.get();
        }
        ModelNode request = new ModelNode();
        request.get(OP).set(READ_ATTRIBUTE_OPERATION);
        ModelNode address = new ModelNode();
        address.add(SUBSYSTEM, "teiid");
        request.get(OP_ADDR).set(address);
        request.get(NAME).set("runtime-version");
        ModelNode result = JBoss7ServerUtil.executeRequest(parentServer, jboss7Server, request);
        return new TeiidServerVersion(result.asString());
    }
}

