/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.adapter;

import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;

public class JBossServerUtil {
    public static boolean isJBossServerConnected(IServer parentServer, JBossServer jbossServer) throws Exception {
        if (!JBossServerUtil.serverStarted(parentServer)) {
            return false;
        }
        return JBossServerUtil.isHostConnected(jbossServer.getHost(), jbossServer.getJBossWebPort());
    }

    protected static boolean isHostConnected(String host, int port) throws Exception {
        Socket socket = null;
        Reader in = null;
        InetSocketAddress endPoint = new InetSocketAddress(host, port);
        if (endPoint.isUnresolved()) {
            DqpPlugin.Util.log(2, DqpPlugin.Util.getString("jbossServerConnectionFailureMessage", (Object)endPoint));
            return false;
        }
        try {
            socket = new Socket();
            socket.connect(endPoint, 1024);
            return true;
        }
        catch (Exception ex) {
            if (DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/jboss/connection")) {
                DqpPlugin.Util.log((Throwable)ex);
            }
            return false;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (socket != null && socket.isConnected()) {
                    socket.close();
                    socket = null;
                }
            }
            catch (Exception ex2) {
                DqpPlugin.Util.log((Throwable)ex2);
            }
        }
    }

    public static boolean isTeiidServer(IServer parentServer, JBossServer jbossServer) throws Exception {
        return JBossServerUtil.serverStarted(parentServer);
    }

    protected static boolean serverStarted(IServer server) {
        if (server == null) {
            return false;
        }
        return server.getServerState() == 2;
    }

    public static ITeiidServerVersion getTeiidRuntimeVersion(IServer parentServer, JBossServer jbossServer) {
        return TeiidServerVersion.Version.TEIID_7_7.get();
    }
}

