/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.teiid.core.designer.properties.PropertyDefinition;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.translators.TranslatorOverride;
import org.teiid.designer.core.translators.TranslatorOverrideProperty;
import org.teiid.designer.core.translators.TranslatorProperty;
import org.teiid.designer.core.translators.TranslatorPropertyDefinition;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidTranslator;
import org.teiid.designer.runtime.spi.TeiidPropertyDefinition;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;

public class TranslatorUtils {
    public static ITeiidServer getDefaultServer() {
        return DqpPlugin.getInstance().getServerManager().getDefaultServer();
    }

    public static PropertyDefinition[] getTranslatorPropertyDefinitions(String translatorName, ITeiidTranslator.TranslatorPropertyType type) {
        if (StringUtilities.isEmpty((String)translatorName)) {
            throw new IllegalArgumentException();
        }
        ITeiidServer defaultServer = TranslatorUtils.getDefaultServer();
        if (defaultServer != null && defaultServer.isConnected()) {
            try {
                ITeiidTranslator translator = defaultServer.getTranslator(translatorName);
                if (translator != null) {
                    if (type == ITeiidTranslator.TranslatorPropertyType.OVERRIDE) {
                        return TranslatorUtils.getOverrideDefinitions(defaultServer, translator);
                    }
                    if (type == ITeiidTranslator.TranslatorPropertyType.IMPORT) {
                        return TranslatorUtils.getImportDefinitions(defaultServer, translator);
                    }
                    if (type == ITeiidTranslator.TranslatorPropertyType.EXTENSION_METADATA) {
                        return TranslatorUtils.getExtensionDefinitions(defaultServer, translator);
                    }
                    return new PropertyDefinition[0];
                }
            }
            catch (Exception e) {
                DqpPlugin.Util.log(4, (Throwable)e, DqpPlugin.Util.getString("errorObtainingTranslatorProperties", new Object[]{translatorName, defaultServer.getHost()}));
            }
        }
        return null;
    }

    private static PropertyDefinition[] getOverrideDefinitions(ITeiidServer defaultServer, ITeiidTranslator translator) {
        ArrayList<TranslatorProperty> props = new ArrayList<TranslatorProperty>();
        if (defaultServer.getServerVersion().isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_6)) {
            for (TeiidPropertyDefinition propDefn : translator.getPropertyDefinitions()) {
                TranslatorProperty prop = new TranslatorProperty(propDefn.getPropertyTypeClassName());
                prop.setAdvanced(propDefn.isAdvanced());
                prop.setDescription(propDefn.getDescription());
                prop.setDisplayName(propDefn.getDisplayName());
                prop.setId(propDefn.getName());
                prop.setMasked(propDefn.isMasked());
                prop.setModifiable(propDefn.isModifiable());
                prop.setRequired(propDefn.isRequired());
                prop.setDefaultValue(propDefn.getDefaultValue() == null ? "" : propDefn.getDefaultValue().toString());
                if (propDefn.isConstrainedToAllowedValues()) {
                    Collection values = propDefn.getAllowedValues();
                    prop.setAllowedValues(new String[values.size()]);
                    int i = 0;
                    for (Object value : values) {
                        prop.getAllowedValues()[i++] = value.toString();
                    }
                } else {
                    String type = propDefn.getPropertyTypeClassName();
                    if (Boolean.class.getName().equals(type) || Boolean.TYPE.getName().equals(type)) {
                        prop.setAllowedValues(new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()});
                    }
                }
                props.add(prop);
            }
        }
        return props.toArray(new PropertyDefinition[props.size()]);
    }

    private static PropertyDefinition[] getImportDefinitions(ITeiidServer defaultServer, ITeiidTranslator translator) {
        ArrayList<TranslatorProperty> props = new ArrayList<TranslatorProperty>();
        if (defaultServer.getServerVersion().isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_6)) {
            for (TeiidPropertyDefinition propDefn : translator.getImportPropertyDefinitions()) {
                TranslatorProperty prop = new TranslatorProperty(propDefn.getPropertyTypeClassName());
                prop.setAdvanced(propDefn.isAdvanced());
                prop.setDescription(propDefn.getDescription());
                prop.setDisplayName(propDefn.getDisplayName());
                prop.setId(propDefn.getName());
                prop.setMasked(propDefn.isMasked());
                prop.setModifiable(propDefn.isModifiable());
                prop.setRequired(propDefn.isRequired());
                prop.setDefaultValue(propDefn.getDefaultValue() == null ? "" : propDefn.getDefaultValue().toString());
                if (propDefn.isConstrainedToAllowedValues()) {
                    Collection values = propDefn.getAllowedValues();
                    prop.setAllowedValues(new String[values.size()]);
                    int i = 0;
                    for (Object value : values) {
                        prop.getAllowedValues()[i++] = value.toString();
                    }
                } else {
                    String type = propDefn.getPropertyTypeClassName();
                    if (Boolean.class.getName().equals(type) || Boolean.TYPE.getName().equals(type)) {
                        prop.setAllowedValues(new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()});
                    }
                }
                props.add(prop);
            }
        }
        return props.toArray(new PropertyDefinition[props.size()]);
    }

    private static PropertyDefinition[] getExtensionDefinitions(ITeiidServer defaultServer, ITeiidTranslator translator) {
        ArrayList<TranslatorProperty> props = new ArrayList<TranslatorProperty>();
        if (defaultServer.getServerVersion().isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_6)) {
            for (TeiidPropertyDefinition propDefn : translator.getExtensionPropertyDefinitions()) {
                TranslatorProperty prop = new TranslatorProperty(propDefn.getPropertyTypeClassName());
                prop.setAdvanced(propDefn.isAdvanced());
                prop.setDescription(propDefn.getDescription());
                prop.setDisplayName(propDefn.getDisplayName());
                prop.setId(propDefn.getName());
                prop.setMasked(propDefn.isMasked());
                prop.setModifiable(propDefn.isModifiable());
                prop.setRequired(propDefn.isRequired());
                prop.setDefaultValue(propDefn.getDefaultValue() == null ? "" : propDefn.getDefaultValue().toString());
                if (propDefn.isConstrainedToAllowedValues()) {
                    Collection values = propDefn.getAllowedValues();
                    prop.setAllowedValues(new String[values.size()]);
                    int i = 0;
                    for (Object value : values) {
                        prop.getAllowedValues()[i++] = value.toString();
                    }
                } else {
                    String type = propDefn.getPropertyTypeClassName();
                    if (Boolean.class.getName().equals(type) || Boolean.TYPE.getName().equals(type)) {
                        prop.setAllowedValues(new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()});
                    }
                }
                props.add(prop);
            }
        }
        return props.toArray(new PropertyDefinition[props.size()]);
    }

    public static TranslatorOverride createOverride(String type, Properties properties, ITeiidTranslator.TranslatorPropertyType defType) {
        TranslatorOverride override = new TranslatorOverride(type, properties);
        PropertyDefinition[] propertyDefinitionsFromServer = TranslatorUtils.getTranslatorPropertyDefinitions(type, defType);
        if (propertyDefinitionsFromServer != null) {
            ArrayList<PropertyDefinition> newServerProps = new ArrayList<PropertyDefinition>();
            PropertyDefinition[] propertyDefinitionArray = propertyDefinitionsFromServer;
            int n = propertyDefinitionsFromServer.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDefinition propDefn = propertyDefinitionArray[n2];
                newServerProps.add(propDefn);
                ++n2;
            }
            if (!properties.isEmpty()) {
                for (Object key : properties.keySet()) {
                    String keyStr = (String)key;
                    String value = (String)properties.get(key);
                    PropertyDefinition serverPropDefn = null;
                    PropertyDefinition[] propertyDefinitionArray2 = propertyDefinitionsFromServer;
                    int n3 = propertyDefinitionsFromServer.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        PropertyDefinition propDefn = propertyDefinitionArray2[n4];
                        if (keyStr.equals(propDefn.getId())) {
                            serverPropDefn = propDefn;
                            newServerProps.remove(serverPropDefn);
                            break;
                        }
                        ++n4;
                    }
                    if (serverPropDefn == null) continue;
                    TranslatorOverrideProperty newProp = new TranslatorOverrideProperty(new TranslatorPropertyDefinition(serverPropDefn), value);
                    override.addProperty(newProp);
                }
            }
            for (PropertyDefinition propDefn : newServerProps) {
                override.addProperty(new TranslatorOverrideProperty(new TranslatorPropertyDefinition(propDefn), null));
            }
        }
        return override;
    }

    public static Collection<ITeiidTranslator> getTranslators() {
        Collection<Object> translators = Collections.emptyList();
        ITeiidServer defaultServer = TranslatorUtils.getDefaultServer();
        if (defaultServer != null && defaultServer.isConnected()) {
            try {
                translators = defaultServer.getTranslators();
            }
            catch (Exception e) {
                DqpPlugin.Util.log(4, (Throwable)e, "Error retrieving translators for the server: " + defaultServer.getDisplayName());
            }
        }
        return translators;
    }
}

