/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.preview;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.common.xmi.XMIHeader;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.workspace.ModelFileUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.importer.Messages;
import org.teiid.designer.transformation.util.TransformationHelper;

public class DependentObjectHelper {
    private EObject targetObject;
    private Set<EObject> sourceTables = new HashSet<EObject>();
    boolean includeIntermediates = true;
    public static final int SEARCHABLE = 0;
    public static final int ALL_EXCEPT_LIKE = 1;
    public static final int LIKE_ONLY = 2;
    public static final int UNSEARCHABLE = 3;
    public static final String SEARCHABLE_STRING = "SEARCHABLE";
    public static final String ALL_EXCEPT_LIKE_STRING = "ALL_EXCEPT_LIKE";
    public static final String LIKE_ONLY_STRING = "LIKE_ONLY";
    public static final String UNSEARCHABLE_STRING = "UNSEARCHABLE";
    public static final String UNKNOWN_STRING = "UNKNOWN";
    public static final String NULL_STRING = "NULL";

    public DependentObjectHelper(EObject targetGroup) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)targetGroup, (String)"DependentObjectHelper has NULL group. Expected Non-Null");
        this.targetObject = targetGroup;
        this.includeIntermediates = true;
        this.calculateDependentObjects();
    }

    public EObject getVGroup() {
        return this.targetObject;
    }

    private void calculateDependentObjects() throws ModelWorkspaceException {
        this.findSourceTables();
    }

    public Set<EObject> getDependentObjects() {
        return this.sourceTables;
    }

    private void findSourceTables() throws ModelWorkspaceException {
        ModelResource targetMR = ModelerCore.getModelEditor().findModelResource(this.targetObject);
        boolean isVirtual = ModelType.VIRTUAL_LITERAL.equals(((EmfResource)targetMR.getEmfResource()).getModelAnnotation().getModelType());
        if (!isVirtual) {
            return;
        }
        EObject transformationEObject = this.getTransformation(this.targetObject);
        Iterator<EObject> sourceIter = this.getSourceEObjects(transformationEObject).iterator();
        EObject nextSourceEObject = null;
        while (sourceIter.hasNext()) {
            nextSourceEObject = sourceIter.next();
            if (nextSourceEObject.eIsProxy()) {
                nextSourceEObject = this.getRealEObjectFromProxy(nextSourceEObject);
            }
            if (nextSourceEObject == null) continue;
            this.addSourceTable(nextSourceEObject);
            if (!this.isVirtual(nextSourceEObject)) continue;
            this.addDependencies(nextSourceEObject);
        }
    }

    private EObject getRealEObjectFromProxy(EObject proxyEObj) {
        EObject eObjectResult = null;
        if (proxyEObj.eIsProxy() && proxyEObj instanceof EObjectImpl) {
            try {
                String sUUIDFrag = ((EObjectImpl)proxyEObj).eProxyURI().fragment();
                eObjectResult = (EObject)ModelerCore.getModelContainer().getEObjectFinder().find((Object)sUUIDFrag);
            }
            catch (CoreException e) {
                DqpPlugin.Util.log(4, (Throwable)e, Messages.DependentObjectHelper_getRealEObjectFromProxyError);
            }
        }
        return eObjectResult;
    }

    private void addSourceTable(EObject sourceTable) {
        this.sourceTables.add(sourceTable);
    }

    private void addDependencies(EObject virtualSource) {
        ArrayList<EObject> virtualSources = new ArrayList<EObject>();
        EObject transformationEObject = this.getTransformation(virtualSource);
        if (transformationEObject != null) {
            Iterator<EObject> sourceIter = this.getSourceEObjects(transformationEObject).iterator();
            EObject nextSourceEObject = null;
            while (sourceIter.hasNext()) {
                nextSourceEObject = sourceIter.next();
                if (nextSourceEObject.eIsProxy()) {
                    nextSourceEObject = this.getRealEObjectFromProxy(nextSourceEObject);
                }
                if (nextSourceEObject == null) continue;
                if (this.isVirtual(nextSourceEObject)) {
                    virtualSources.add(nextSourceEObject);
                }
                this.addSourceTable(nextSourceEObject);
            }
        }
        if (!virtualSources.isEmpty()) {
            Iterator vIter = virtualSources.iterator();
            while (vIter.hasNext()) {
                this.addDependencies((EObject)vIter.next());
            }
        }
    }

    private EObject getTransformation(EObject targetVirtualGroupEObject) {
        return TransformationHelper.getTransformationMappingRoot((EObject)targetVirtualGroupEObject);
    }

    private List<EObject> getSourceEObjects(EObject transformationEObject) {
        SqlTransformationMappingRoot mappingRoot;
        EList inputEObjects;
        if (transformationEObject instanceof SqlTransformationMappingRoot && (inputEObjects = (mappingRoot = (SqlTransformationMappingRoot)transformationEObject).getInputs()) != null) {
            return inputEObjects;
        }
        return Collections.emptyList();
    }

    public boolean isVirtual(EObject eObject) {
        File newFile;
        XMIHeader header;
        URI theUri;
        Resource resource = eObject.eResource();
        if (resource instanceof EmfResource) {
            return ModelType.VIRTUAL_LITERAL.equals(((EmfResource)resource).getModelAnnotation().getModelType());
        }
        return resource == null && eObject.eIsProxy() && (theUri = ((InternalEObject)eObject).eProxyURI().trimFragment()).isFile() && (header = ModelFileUtil.getXmiHeader((File)(newFile = new File(theUri.toFileString())))) != null && ModelType.VIRTUAL_LITERAL.equals(ModelType.get((String)header.getModelType()));
    }
}

