/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.preview;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.extension.CoreModelExtensionAssistant;
import org.teiid.designer.metamodels.relational.extension.CoreModelExtensionConstants;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.importer.Messages;
import org.teiid.designer.runtime.preview.DependentObjectHelper;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidVdb;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.transformation.ddl.TeiidModelToDdlGenerator;

@ThreadSafe
public final class PreviewManager {
    private static final String DYNAMIC_VDB_SUFFIX = "-vdb.xml";
    public static final String IMPORT_SRC_MODEL = "SrcModel";
    IStatus vdbDeploymentStatus = null;
    EObject targetObject;
    String dynamicVdb;
    String vdbName;
    String deploymentName;
    String modelName;
    DependentObjectHelper helper;

    public PreviewManager(EObject targetObject) {
        this.targetObject = targetObject;
        ModelResource targetMR = this.getModelResource(targetObject);
        String modelName = targetMR.getItemName();
        if (modelName.toUpperCase().endsWith(".XMI")) {
            int length = modelName.length();
            modelName = modelName.substring(0, length - 4);
        }
        String uuid = new org.teiid.core.designer.id.UUID(UUID.randomUUID()).exportableForm();
        this.vdbName = "PREVIEW-" + uuid;
        this.deploymentName = String.valueOf(this.vdbName) + DYNAMIC_VDB_SUFFIX;
    }

    public String getDynamicVdbString() throws ModelWorkspaceException {
        if (this.dynamicVdb == null) {
            try {
                this.generateDynamicVdb();
            }
            catch (ModelWorkspaceException e) {
                e.printStackTrace();
            }
        }
        return this.dynamicVdb;
    }

    public String getPreviewVdbName() {
        return this.vdbName;
    }

    public String getPreviewVdbDeploymentName() {
        return this.deploymentName;
    }

    private void generateDynamicVdb() throws ModelWorkspaceException {
        if (this.dynamicVdb == null) {
            this.dynamicVdb = this.createDynamicVdb();
        }
    }

    public IStatus deployDynamicVdb() {
        try {
            this.generateDynamicVdb();
        }
        catch (ModelWorkspaceException e) {
            e.printStackTrace();
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        String message = null;
                        message = PreviewManager.this.getTimeoutPrefSecs() < 1 ? "No TIMEOUT defined" : "Timeout deploying Preview VDB was " + PreviewManager.this.getTimeoutPrefSecs();
                        monitor.beginTask(message, 100);
                        PreviewManager.this.vdbDeploymentStatus = PreviewManager.this.deployDynamicVdb(PreviewManager.this.dynamicVdb, monitor);
                    }
                    catch (Throwable e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(false, true, op);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            this.vdbDeploymentStatus = new Status(4, "org.teiid.designer.dqp", 0, cause.getLocalizedMessage(), cause);
            DqpPlugin.Util.log(this.vdbDeploymentStatus);
        }
        catch (InterruptedException interruptedException) {
            this.vdbDeploymentStatus = new Status(4, "org.teiid.designer.dqp", "Deploy Preview Dynamic VDB interrupted");
            DqpPlugin.Util.log(this.vdbDeploymentStatus);
        }
        return this.vdbDeploymentStatus;
    }

    public IStatus undeployDynamicVdb() {
        IStatus resultStatus = Status.OK_STATUS;
        try {
            ITeiidVdb deployedImportVdb = this.getDefaultServer().getVdb(this.vdbName);
            if (deployedImportVdb != null) {
                this.getDefaultServer().undeployDynamicVdb(deployedImportVdb.getName());
            }
        }
        catch (Exception exception) {
            resultStatus = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.ImportManagerUndeployVdbError, (Object)this.vdbName));
        }
        return resultStatus;
    }

    public IStatus deployDynamicVdb(String dynamicVdbString, IProgressMonitor monitor) {
        Object resultStatus = Status.OK_STATUS;
        int workRemaining = 100;
        monitor.worked(10);
        workRemaining -= 10;
        try {
            ITeiidServer server = DqpPlugin.getInstance().getServerManager().getDefaultServer();
            server.deployDynamicVdb(this.deploymentName, (InputStream)new ByteArrayInputStream(dynamicVdbString.getBytes("UTF-8")));
        }
        catch (Exception exception) {
            resultStatus = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.ImportManagerDeployVdbError, (Object)this.vdbName));
            return resultStatus;
        }
        monitor.worked(10);
        workRemaining -= 10;
        int timeoutSec = DqpPlugin.getInstance().getPreferences().getInt("org.teiid.designer.dqp.preferences.TeiidImporterTimeoutSec", 120);
        boolean finishedLoading = false;
        try {
            finishedLoading = this.waitForVDBLoad(this.vdbName, timeoutSec, monitor, workRemaining);
        }
        catch (InterruptedException interruptedException) {
            resultStatus = new Status(8, "org.teiid.designer.dqp", NLS.bind((String)Messages.ImportManagerVdbLoadingInterruptedError, (Object)this.vdbName));
            return resultStatus;
        }
        catch (Exception exception) {
            resultStatus = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.ImportManagerVdbLoadingError, (Object)this.vdbName));
            return resultStatus;
        }
        if (finishedLoading) {
            boolean isVDBActive;
            try {
                isVDBActive = this.getDefaultServer().isVdbActive(this.vdbName);
            }
            catch (Exception exception) {
                resultStatus = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.ImportManagerVdbGetStateError, (Object)this.vdbName));
                return resultStatus;
            }
            resultStatus = isVDBActive ? Status.OK_STATUS : new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.ImportManagerVdbInactiveStateError, (Object)this.vdbName));
        } else {
            resultStatus = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.ImportManagerVdbLoadingNotCompleteError, (Object)timeoutSec));
        }
        return resultStatus;
    }

    public IStatus undeployVdb(String importerVdbName) {
        Status resultStatus = null;
        try {
            ITeiidVdb deployedImportVdb = this.getDefaultServer().getVdb(importerVdbName);
            if (deployedImportVdb != null) {
                this.getDefaultServer().undeployDynamicVdb(deployedImportVdb.getName());
            }
        }
        catch (Exception exception) {
            resultStatus = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.ImportManagerUndeployVdbError, (Object)importerVdbName));
        }
        return resultStatus;
    }

    public String createDynamicVdb() throws ModelWorkspaceException {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        sb.append("\n<vdb name=\"" + this.vdbName + "\" version=\"1\">");
        sb.append("\n\t<description>Importer VDB</description>");
        sb.append("\n\t<property name=\"UseConnectorMetadata\" value=\"true\" />");
        sb.append("\n\t<property name=\"deployment-name\" value=\"" + this.deploymentName + "\" />");
        Collection<VdbSourceModelInfo> vdbImports = this.getVdbSourceModelInfos();
        for (VdbSourceModelInfo info : vdbImports) {
            sb.append(info.getXml());
        }
        Collection<ModelFragmentInfo> modelFragments = this.getModelFragments();
        for (ModelFragmentInfo info : modelFragments) {
            sb.append(info.getModelXml());
        }
        String transOverrides = this.getTranslatorOverrides(modelFragments);
        if (StringUtilities.isNotEmpty((String)transOverrides)) {
            sb.append(transOverrides);
        }
        sb.append("\n</vdb>");
        return sb.toString();
    }

    private boolean waitForVDBLoad(String vdbName, int timeoutInSecs, IProgressMonitor monitor, int workRemaining) throws Exception {
        int increments = timeoutInSecs / 5;
        int workIncrement = Math.round((float)workRemaining / (float)increments);
        long waitUntil = System.currentTimeMillis() + (long)(timeoutInSecs * 1000);
        if (timeoutInSecs < 1) {
            waitUntil = Long.MAX_VALUE;
        }
        boolean first = true;
        do {
            boolean hasValidityErrors;
            block6: {
                if (!first) {
                    try {
                        Thread.sleep(5000L);
                        break block6;
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
                first = false;
            }
            monitor.worked(workIncrement);
            if (monitor.isCanceled()) {
                monitor.setCanceled(true);
                throw new InterruptedException("The operation was cancelled");
            }
            boolean isActive = this.getDefaultServer().isVdbActive(vdbName);
            boolean isLoading = this.getDefaultServer().isVdbLoading(vdbName);
            boolean hasFailed = this.getDefaultServer().hasVdbFailed(vdbName);
            boolean bl = hasValidityErrors = !this.getDefaultServer().getVdb(vdbName).getValidityErrors().isEmpty();
            if (isLoading && !hasFailed && !hasValidityErrors && !isActive) continue;
            return true;
        } while (System.currentTimeMillis() < waitUntil);
        return false;
    }

    private String getTranslatorOverrides(Collection<ModelFragmentInfo> modelFragments) {
        StringBuffer sb = new StringBuffer();
        Iterator<ModelFragmentInfo> iterator = modelFragments.iterator();
        while (iterator.hasNext()) {
            String value;
            String keyStr;
            ConnectionInfoHelper helper = new ConnectionInfoHelper();
            ModelFragmentInfo info = iterator.next();
            ModelResource mr = info.getModelResource();
            String translatorType = helper.getTranslatorName(mr);
            if (StringUtilities.isEmpty((String)translatorType)) continue;
            String translatorOverrideName = String.valueOf(translatorType) + "_override";
            Properties translatorProps = helper.getTranslatorOverrideProperties(mr);
            Properties nonNameProperties = new Properties();
            for (Object key : translatorProps.keySet()) {
                keyStr = (String)key;
                value = translatorProps.getProperty(keyStr);
                if (keyStr.toUpperCase().equals("NAME")) continue;
                nonNameProperties.put(keyStr, value);
            }
            if (nonNameProperties.isEmpty()) continue;
            sb.append("\n\t\t<translator name=\"" + translatorOverrideName + "\" type=\"" + translatorType + "\" >");
            for (Object key : nonNameProperties.keySet()) {
                keyStr = (String)key;
                value = nonNameProperties.getProperty(keyStr);
                sb.append("\n\t\t\t<property name=\"" + keyStr + "\" value=\"" + value + "\" />");
            }
            sb.append("\n\t\t</translator>");
        }
        return sb.toString();
    }

    public String getDisplayName() throws Exception {
        return this.getDefaultServer().getParentName();
    }

    public void deployDynamicVdb(String deploymentName, InputStream inStream) throws Exception {
        this.getDefaultServer().deployDynamicVdb(deploymentName, inStream);
    }

    public ITeiidServerVersion getServerVersion() {
        ITeiidServer importServer = this.getDefaultServer();
        if (importServer == null || !importServer.isConnected()) {
            return null;
        }
        return importServer.getServerVersion();
    }

    private int getTimeoutPrefSecs() {
        return DqpPlugin.getInstance().getPreferences().getInt("org.teiid.designer.dqp.preferences.TeiidImporterTimeoutSec", 120);
    }

    private Collection<ModelFragmentInfo> getModelFragments() throws ModelWorkspaceException {
        ArrayList<ModelFragmentInfo> modelFragments = new ArrayList<ModelFragmentInfo>();
        ModelResource targetMR = this.getModelResource(this.targetObject);
        modelFragments.add(new ModelFragmentInfo(this.targetObject, targetMR));
        boolean isVirtual = ModelType.VIRTUAL_LITERAL.equals(((EmfResource)targetMR.getEmfResource()).getModelAnnotation().getModelType());
        if (isVirtual) {
            DependentObjectHelper helper = new DependentObjectHelper(this.targetObject);
            Set<EObject> allDependentObjects = helper.getDependentObjects();
            for (EObject eObj : allDependentObjects) {
                ModelResource nextMR = this.getModelResource(eObj);
                if (this.isVdbSourceModel(nextMR)) continue;
                boolean newMR = true;
                for (ModelFragmentInfo info : modelFragments) {
                    if (!info.matchesModelResource(nextMR)) continue;
                    info.addObject(eObj);
                    newMR = false;
                    break;
                }
                if (!newMR) continue;
                modelFragments.add(new ModelFragmentInfo(eObj, nextMR));
            }
        }
        return modelFragments;
    }

    private Collection<VdbSourceModelInfo> getVdbSourceModelInfos() throws ModelWorkspaceException {
        boolean isVirtual;
        ArrayList<VdbSourceModelInfo> vdbSources = new ArrayList<VdbSourceModelInfo>();
        ModelResource targetMR = this.getModelResource(this.targetObject);
        if (this.isVdbSourceModel(targetMR)) {
            String vdbName = this.getVdbName(targetMR);
            int version = 1;
            String versionStr = this.getVdbVersion(targetMR);
            if (StringUtilities.isNotEmpty((String)versionStr)) {
                try {
                    version = Integer.parseInt(versionStr);
                }
                catch (NumberFormatException ex) {
                    DqpPlugin.Util.log(4, (Throwable)ex, ex.getMessage());
                }
            }
            vdbSources.add(new VdbSourceModelInfo(targetMR, vdbName, version));
        }
        if (isVirtual = ModelType.VIRTUAL_LITERAL.equals(((EmfResource)targetMR.getEmfResource()).getModelAnnotation().getModelType())) {
            DependentObjectHelper helper = new DependentObjectHelper(this.targetObject);
            Set<EObject> allDependentObjects = helper.getDependentObjects();
            for (EObject eObj : allDependentObjects) {
                ModelResource nextMR = this.getModelResource(eObj);
                if (!this.isVdbSourceModel(nextMR)) continue;
                String vdbName = this.getVdbName(nextMR);
                boolean newMR = true;
                for (VdbSourceModelInfo info : vdbSources) {
                    if (!info.matchesModelResource(nextMR)) continue;
                    newMR = false;
                    break;
                }
                if (!newMR) continue;
                int version = 1;
                String versionStr = this.getVdbVersion(targetMR);
                if (StringUtilities.isNotEmpty((String)versionStr)) {
                    try {
                        version = Integer.parseInt(versionStr);
                    }
                    catch (NumberFormatException ex) {
                        DqpPlugin.Util.log(4, (Throwable)ex, ex.getMessage());
                    }
                }
                vdbSources.add(new VdbSourceModelInfo(nextMR, vdbName, version));
            }
        }
        return vdbSources;
    }

    private ModelResource getModelResource(EObject eObj) {
        return ModelerCore.getModelEditor().findModelResource(eObj);
    }

    private ITeiidServer getDefaultServer() {
        return DqpPlugin.getInstance().getServerManager().getDefaultServer();
    }

    private boolean isVdbSourceModel(ModelResource modelResource) {
        if (modelResource != null) {
            try {
                ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
                CoreModelExtensionAssistant assistant = (CoreModelExtensionAssistant)registry.getModelExtensionAssistant(CoreModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
                if (assistant != null) {
                    return assistant.isVdbSourceModel(modelResource);
                }
            }
            catch (Exception ex) {
                DqpPlugin.Util.log(4, (Throwable)ex, ex.getMessage());
            }
        }
        return false;
    }

    private String getVdbName(ModelResource modelResource) {
        if (modelResource != null) {
            try {
                ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
                CoreModelExtensionAssistant assistant = (CoreModelExtensionAssistant)registry.getModelExtensionAssistant(CoreModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
                if (assistant != null) {
                    return assistant.getVdbName(modelResource);
                }
            }
            catch (Exception ex) {
                DqpPlugin.Util.log(4, (Throwable)ex, ex.getMessage());
            }
        }
        return null;
    }

    private String getVdbVersion(ModelResource modelResource) {
        if (modelResource != null) {
            try {
                ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
                CoreModelExtensionAssistant assistant = (CoreModelExtensionAssistant)registry.getModelExtensionAssistant(CoreModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
                if (assistant != null) {
                    return assistant.getVdbVersion(modelResource);
                }
            }
            catch (Exception ex) {
                DqpPlugin.Util.log(4, (Throwable)ex, ex.getMessage());
            }
        }
        return null;
    }

    class DynamicVdbDeployer {
        DynamicVdbDeployer() {
        }

        public IStatus deployDynamicVdb(String vdbFileName, String contents, IProgressMonitor monitor) {
            IStatus resultStatus = Status.OK_STATUS;
            try {
                PreviewManager.this.getDefaultServer().deployDynamicVdb(vdbFileName, (InputStream)new ByteArrayInputStream(contents.getBytes("UTF-8")));
            }
            catch (Exception exception) {
                resultStatus = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.ImportManagerDeployVdbError, (Object)vdbFileName));
                return resultStatus;
            }
            return resultStatus;
        }
    }

    class ModelFragmentInfo {
        ModelResource modelResource;
        Set<EObject> eObjects = new HashSet<EObject>();

        public ModelFragmentInfo(EObject eObj, ModelResource mr) {
            this.eObjects.add(eObj);
            this.modelResource = mr;
        }

        private String getModelXml() throws ModelWorkspaceException {
            StringBuffer sb = new StringBuffer();
            boolean isVirtual = ModelType.VIRTUAL_LITERAL.equals(((EmfResource)this.modelResource.getEmfResource()).getModelAnnotation().getModelType());
            String modelName = this.modelResource.getItemName();
            if (modelName.toUpperCase().endsWith(".XMI")) {
                int length = modelName.length();
                modelName = modelName.substring(0, length - 4);
            }
            String modelType = this.modelResource.getModelType().getName();
            ConnectionInfoHelper helper = new ConnectionInfoHelper();
            String translatorName = helper.getTranslatorName(this.modelResource);
            if (translatorName == null) {
                translatorName = "";
            }
            String jndiProp = helper.getJndiProperty(this.modelResource);
            sb.append("\n\t<model name=\"" + modelName + "\" type=\"" + modelType + "\" visible=\"true\">");
            if (!isVirtual) {
                sb.append("\n\t\t<source name=\"" + modelName + "\" translator-name=\"" + translatorName + "\" connection-jndi-name=\"" + jndiProp + "\" />");
            }
            ArrayList<String> statements = new ArrayList<String>(this.eObjects.size());
            TeiidModelToDdlGenerator generator = new TeiidModelToDdlGenerator(true);
            generator.setIncludeFKs(false);
            generator.setIsVirtual(isVirtual);
            for (EObject eObj : this.eObjects) {
                String statement = generator.getStatement(eObj);
                if (StringUtilities.isEmpty((String)statement)) continue;
                statements.add(statement);
            }
            if (!statements.isEmpty()) {
                sb.append("\n\t\t<metadata type=\"DDL\"><![CDATA[");
                for (String statement : statements) {
                    sb.append("\n").append(statement);
                }
                sb.append("]]></metadata>");
            }
            sb.append("\n\t</model>");
            return sb.toString();
        }

        private boolean matchesModelResource(ModelResource mr) {
            return mr == this.modelResource;
        }

        public ModelResource getModelResource() {
            return this.modelResource;
        }

        public Set<EObject> getEObjects() {
            return this.eObjects;
        }

        public void addObject(EObject eObj) {
            this.eObjects.add(eObj);
        }
    }

    class VdbSourceModelInfo {
        ModelResource modelResource;
        String vdbName;
        int version;

        public VdbSourceModelInfo(ModelResource mr, String vdbName, int version) {
            this.modelResource = mr;
            this.vdbName = vdbName;
            this.version = version;
        }

        public ModelResource getModelResource() {
            return this.modelResource;
        }

        public String getVdbName() {
            return this.vdbName;
        }

        public int getVdbVersion() {
            return this.version;
        }

        private boolean matchesModelResource(ModelResource mr) {
            return mr == this.modelResource;
        }

        private String getXml() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n\t<import-vdb name=\"" + this.vdbName + "\" version=\"" + this.version + "\" import-data-policies=\"false\"/>");
            return sb.toString();
        }
    }
}

