/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.camel.navigator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelBrowsableEndpointMBean;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelContextMBean;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelEndpointMBean;
import org.fusesource.ide.foundation.core.util.URIs;
import org.fusesource.ide.foundation.ui.drop.DropHandler;
import org.fusesource.ide.foundation.ui.drop.DropHandlerFactory;
import org.fusesource.ide.foundation.ui.tree.NodeSupport;
import org.fusesource.ide.foundation.ui.util.ContextMenuProvider;
import org.fusesource.ide.foundation.ui.util.Shells;
import org.fusesource.ide.jmx.camel.CamelJMXPlugin;
import org.fusesource.ide.jmx.camel.Messages;
import org.fusesource.ide.jmx.camel.navigator.CamelContextNode;
import org.fusesource.ide.jmx.camel.navigator.EndpointSchemeNode;
import org.fusesource.ide.jmx.commons.messages.Exchange;
import org.fusesource.ide.jmx.commons.messages.Exchanges;
import org.fusesource.ide.jmx.commons.messages.IExchange;
import org.fusesource.ide.jmx.commons.messages.IExchangeBrowser;
import org.fusesource.ide.jmx.commons.messages.IMessage;
import org.fusesource.ide.jmx.commons.tree.MessageDropHandler;
import org.fusesource.ide.jmx.commons.tree.MessageDropTarget;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class EndpointNode
extends NodeSupport
implements IExchangeBrowser,
MessageDropTarget,
DropHandlerFactory,
ImageProvider,
ContextMenuProvider {
    private final EndpointSchemeNode schemeNode;
    private final CamelEndpointMBean endpointMBean;
    private String remaining;

    public EndpointNode(EndpointSchemeNode schemeNode, CamelEndpointMBean endpointMBean) {
        super((Node)schemeNode);
        this.schemeNode = schemeNode;
        this.endpointMBean = endpointMBean;
        this.setPropertyBean(endpointMBean);
    }

    public String toString() {
        return this.getRemaining();
    }

    public CamelEndpointMBean getEndpointMBean() {
        return this.endpointMBean;
    }

    public EndpointSchemeNode getSchemeNode() {
        return this.schemeNode;
    }

    public String getRemaining() {
        if (this.remaining == null) {
            this.remaining = URIs.getRemaining((String)this.getEndpointUri());
        }
        return this.remaining;
    }

    public List<IExchange> browseExchanges() {
        ArrayList<IExchange> answer = new ArrayList<IExchange>();
        if (this.endpointMBean instanceof CamelBrowsableEndpointMBean) {
            CamelBrowsableEndpointMBean browsable = (CamelBrowsableEndpointMBean)this.endpointMBean;
            long size = browsable.queueSize();
            try {
                int i = 0;
                while ((long)i < size) {
                    Exchange exchange;
                    String xml = browsable.browseMessageAsXml(Integer.valueOf(i), Boolean.valueOf(true));
                    if (xml != null && (exchange = Exchanges.unmarshalNoNamespaceXmlString((String)xml)) != null) {
                        IMessage in = exchange.getIn();
                        if (in != null) {
                            in.setEndpointUri(this.getEndpointUri());
                        }
                        answer.add((IExchange)exchange);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                CamelJMXPlugin.getLogger().warning("Failed to browse messages for " + (Object)((Object)this) + ". " + e, (Throwable)e);
            }
        }
        return answer;
    }

    public Image getImage() {
        return CamelJMXPlugin.getDefault().getImage("queue.png");
    }

    public DropHandler createDropHandler(DropTargetEvent event) {
        return new MessageDropHandler((MessageDropTarget)this);
    }

    public void dropMessage(IMessage message) {
        try {
            String uri = this.getEndpointUri();
            this.getCamelContextNode().send(uri, message);
        }
        catch (Exception e) {
            CamelJMXPlugin.showUserError("Failed to send message to " + (Object)((Object)this), "Could not send message to " + (Object)((Object)this), e);
        }
    }

    public String getEndpointUri() {
        return this.getEndpointMBean().getEndpointUri();
    }

    public CamelContextNode getCamelContextNode() {
        return this.schemeNode.getEndpointsNode().getCamelContextNode();
    }

    public void provideContextMenu(IMenuManager menu) {
        Action deleteEndpointAction = new Action(Messages.DeleteEndpointAction, 32){

            public void run() {
                EndpointNode.this.showDeleteEndpointDialog();
            }
        };
        deleteEndpointAction.setToolTipText(Messages.DeleteEndpointActionToolTip);
        deleteEndpointAction.setImageDescriptor(CamelJMXPlugin.getDefault().getImageDescriptor("delete.gif"));
        menu.add((IAction)deleteEndpointAction);
    }

    protected void showDeleteEndpointDialog() {
        String message = Messages.bind((String)Messages.DeleteEndpointDialogMessage, (Object)this.endpointMBean.getEndpointUri());
        boolean confirm = MessageDialog.openConfirm((Shell)Shells.getShell(), (String)Messages.DeleteEndpointDialogTitle, (String)message);
        if (confirm) {
            this.deleteEndpoint();
        }
    }

    protected void deleteEndpoint() {
        try {
            CamelContextMBean mbean = this.getCamelContextNode().getCamelContextMBean();
            mbean.removeEndpoints(this.getEndpointUri());
            this.schemeNode.refresh();
        }
        catch (Exception e) {
            CamelJMXPlugin.showUserError("Failed to delete Endpoint", "Failed to delete endpoint: " + this.getEndpointUri(), e);
        }
    }

    protected void doDelete() {
        this.getEndpointUri();
    }

    public boolean equals(Object obj) {
        return obj instanceof EndpointNode && obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.isConnectionAvailable()) {
            return ("CamelEndpointNode-" + this.schemeNode.getEndpointsNode().getCamelContextNode().getManagementName() + "-" + this.toString() + "-" + this.getConnection().getProvider().getName(this.getConnection())).hashCode();
        }
        return super.hashCode();
    }
}

