/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.camel.navigator;

import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.foundation.core.util.Objects;
import org.fusesource.ide.foundation.ui.tree.Refreshable;
import org.fusesource.ide.foundation.ui.tree.RefreshableCollectionNode;
import org.fusesource.ide.foundation.ui.util.ContextMenuProvider;
import org.fusesource.ide.jmx.camel.CamelJMXPlugin;
import org.fusesource.ide.jmx.camel.navigator.EndpointNode;
import org.fusesource.ide.jmx.camel.navigator.EndpointsNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class EndpointSchemeNode
extends RefreshableCollectionNode
implements ImageProvider,
ContextMenuProvider,
Refreshable {
    private final EndpointsNode endpointsNode;
    private final String scheme;

    public EndpointSchemeNode(EndpointsNode endpointsNode, String scheme) {
        super((Node)endpointsNode);
        this.endpointsNode = endpointsNode;
        this.scheme = scheme;
    }

    public EndpointsNode getEndpointsNode() {
        return this.endpointsNode;
    }

    protected void loadChildren() {
    }

    public void refresh() {
        this.endpointsNode.refresh();
    }

    public void provideContextMenu(IMenuManager menu) {
        this.endpointsNode.addCreateEndpointAction(menu, String.valueOf(this.getScheme()) + "://");
    }

    public String toString() {
        return this.scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    public Image getImage() {
        return CamelJMXPlugin.getDefault().getImage("endpoint_folder.png");
    }

    public boolean containsUri(String uri) {
        List list = this.getChildrenList();
        for (Node node : list) {
            EndpointNode enode;
            if (!(node instanceof EndpointNode) || !Objects.equal((Object)uri, (Object)(enode = (EndpointNode)node).getEndpointUri())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        return obj instanceof EndpointSchemeNode && obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.isConnectionAvailable()) {
            return ("CamelEndpointSchemeNode-" + this.endpointsNode.getCamelContextNode().getManagementName() + "-" + this.toString() + "-" + this.getConnection().getProvider().getName(this.getConnection())).hashCode();
        }
        return super.hashCode();
    }
}

