/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.camel.navigator;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.fusesource.ide.foundation.core.functions.Function1;
import org.fusesource.ide.foundation.core.functions.Function1Adapter;
import org.fusesource.ide.foundation.core.functions.FunctionLong;
import org.fusesource.ide.foundation.ui.views.TreeViewSupport;
import org.fusesource.ide.jmx.camel.navigator.ProcessorNodeSupport;
import org.fusesource.ide.jmx.camel.navigator.stats.model.HasTotalStatistics;
import org.fusesource.ide.jmx.commons.messages.IInvocationStatistics;
import org.jboss.tools.jmx.core.tree.Node;

public class ProcessorCallView
extends TreeViewSupport
implements IPropertySheetPage {
    public static final String ID = ProcessorCallView.class.getName();
    private final Node input;

    public ProcessorCallView(Node input) {
        this.input = input;
    }

    public String getColumnConfigurationId() {
        return ID;
    }

    protected String getHelpID() {
        return ID;
    }

    protected void createViewer() {
        super.createViewer();
        this.getViewer().expandAll();
    }

    protected void createColumns() {
        int bounds = 100;
        int column = 0;
        this.clearColumns();
        Object function = new Function1Adapter<Object, String>(String.class){

            public String apply(Object element) {
                if (element instanceof Node) {
                    Node node = (Node)element;
                    return node.toString();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "ID");
        function = new FunctionLong<Object>(){

            public Long apply(Object element) {
                IInvocationStatistics stats = ProcessorCallView.this.getTotalStatistics(element);
                if (stats != null) {
                    return stats.getTotalElapsedTime();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Total Time (ms)");
        function = new FunctionLong<Object>(){

            public Long apply(Object element) {
                IInvocationStatistics stats = ProcessorCallView.this.getNodeStatistics(element);
                if (stats != null) {
                    return stats.getTotalElapsedTime();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Self Time (ms)");
        function = new FunctionLong<Object>(){

            public Long apply(Object element) {
                IInvocationStatistics stats = ProcessorCallView.this.getTotalStatistics(element);
                if (stats != null) {
                    return stats.getCounter();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Count");
    }

    protected IInvocationStatistics getNodeStatistics(Object element) {
        if (element instanceof IInvocationStatistics) {
            return (IInvocationStatistics)element;
        }
        if (element instanceof ProcessorNodeSupport) {
            ProcessorNodeSupport node = (ProcessorNodeSupport)((Object)element);
            return node.getNodeStatistics();
        }
        return null;
    }

    protected IInvocationStatistics getTotalStatistics(Object element) {
        Object node;
        IInvocationStatistics answer;
        if (element instanceof IInvocationStatistics) {
            return (IInvocationStatistics)element;
        }
        if (element instanceof HasTotalStatistics && (answer = (node = (HasTotalStatistics)element).getTotalStatistics()) != null) {
            return answer;
        }
        if (element instanceof ProcessorNodeSupport) {
            node = (ProcessorNodeSupport)((Object)element);
            return ((ProcessorNodeSupport)((Object)node)).getTotalStatistics();
        }
        return null;
    }

    protected void configureViewer() {
        this.viewer.setInput((Object)this.input);
    }

    protected ITreeContentProvider createContentProvider() {
        return new ITreeContentProvider(){

            public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object element) {
                if (element instanceof Node) {
                    Node node = (Node)element;
                    return node.getChildren();
                }
                return null;
            }

            public Object[] getChildren(Object element) {
                if (element instanceof Node) {
                    Node node = (Node)element;
                    return node.getChildren();
                }
                return null;
            }

            public Object getParent(Object element) {
                if (element instanceof Node) {
                    Node node = (Node)element;
                    return node.getParent();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof Node;
            }
        };
    }
}

