/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.camel.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelJMXFacade;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelRouteMBean;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelContextElement;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;
import org.fusesource.ide.foundation.ui.tree.RefreshableCollectionNode;
import org.fusesource.ide.foundation.ui.util.ContextMenuProvider;
import org.fusesource.ide.jmx.camel.CamelJMXPlugin;
import org.fusesource.ide.jmx.camel.navigator.CamelContextNode;
import org.fusesource.ide.jmx.camel.navigator.ProcessorNodeSupport;
import org.fusesource.ide.jmx.camel.navigator.RouteNode;
import org.fusesource.ide.jmx.camel.navigator.stats.model.HasTotalStatistics;
import org.fusesource.ide.jmx.camel.navigator.stats.model.IProcessorStatistics;
import org.fusesource.ide.jmx.camel.navigator.stats.model.IProcessorStatisticsContainer;
import org.fusesource.ide.jmx.commons.messages.IExchange;
import org.fusesource.ide.jmx.commons.messages.IInvocationStatistics;
import org.fusesource.ide.jmx.commons.messages.INodeStatistics;
import org.fusesource.ide.jmx.commons.messages.ITraceExchangeBrowser;
import org.fusesource.ide.jmx.commons.messages.InvocationStatistics;
import org.fusesource.ide.jmx.commons.messages.NodeStatisticsContainer;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class RoutesNode
extends RefreshableCollectionNode
implements ContextMenuProvider,
ITraceExchangeBrowser,
ImageProvider,
HasTotalStatistics {
    private final CamelContextNode camelContextNode;
    private CamelContextElement camelContext;

    public RoutesNode(CamelContextNode camelContextNode) {
        super((Node)camelContextNode);
        this.camelContextNode = camelContextNode;
    }

    public String toString() {
        return "Routes";
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return null;
        }
        return super.getAdapter(adapter);
    }

    public boolean requiresContentsPropertyPage() {
        return false;
    }

    public CamelJMXFacade getFacade() {
        return this.camelContextNode.getFacade();
    }

    public CamelContextNode getCamelContextNode() {
        return this.camelContextNode;
    }

    protected void loadChildren() {
        HashMap<String, RouteNode> routeMap = new HashMap<String, RouteNode>();
        this.camelContext = this.getCamelContextNode().getCamelContext();
        if (this.camelContext != null) {
            List children = this.camelContext.getChildElements();
            for (AbstractCamelModelElement node : children) {
                if (!(node instanceof CamelRouteElement)) continue;
                CamelRouteElement route = (CamelRouteElement)node;
                RouteNode routeNode = new RouteNode(this, route);
                String id = route.getId();
                if (id != null) {
                    routeMap.put(id, routeNode);
                }
                this.addChild((Node)routeNode);
            }
        }
        try {
            List routeMBeans = this.getFacade().getRoutes(this.getManagementName());
            for (CamelRouteMBean mbean : routeMBeans) {
                RouteNode node;
                String routeId = mbean.getRouteId();
                if (routeId == null || (node = (RouteNode)((Object)routeMap.get(routeId))) == null) continue;
                node.setRouteMBean(mbean);
            }
        }
        catch (Exception e) {
            CamelJMXPlugin.getLogger().warning((Throwable)e);
        }
    }

    public String getCamelContextId() {
        return this.camelContextNode.getContextId();
    }

    public String getManagementName() {
        return this.camelContextNode.getManagementName();
    }

    public List<IExchange> browseExchanges() {
        return this.getCamelContextNode().browseExchanges();
    }

    public NodeStatisticsContainer getNodeStatisticsContainer() {
        return this.getCamelContextNode().getNodeStatisticsContainer();
    }

    @Override
    public IInvocationStatistics getTotalStatistics() {
        NodeStatisticsContainer container = this.getNodeStatisticsContainer();
        if (container instanceof IProcessorStatisticsContainer) {
            IProcessorStatisticsContainer processorContainer = (IProcessorStatisticsContainer)container;
            Map<String, IProcessorStatistics> map = processorContainer.getNodeStatsMap();
            Collection<IProcessorStatistics> values = map.values();
            InvocationStatistics stats = new InvocationStatistics();
            for (IProcessorStatistics statistics : values) {
                stats.combineChild((INodeStatistics)statistics);
            }
            return stats;
        }
        return null;
    }

    public void provideContextMenu(IMenuManager menu) {
        this.getCamelContextNode().provideContextMenu(menu);
    }

    public List<IPropertySource> getAllProcessorsPropertySourceList() {
        Node[] children;
        ArrayList<IPropertySource> answer = new ArrayList<IPropertySource>();
        Node[] nodeArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            if (node instanceof ProcessorNodeSupport) {
                ProcessorNodeSupport processor = (ProcessorNodeSupport)node;
                processor.appendAllProcessorSourceList(answer);
            }
            ++n2;
        }
        return answer;
    }

    public Image getImage() {
        return CamelJMXPlugin.getDefault().getImage("camel_route_folder.png");
    }

    public boolean equals(Object obj) {
        return obj instanceof RoutesNode && obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.isConnectionAvailable() && this.getConnection().isConnected()) {
            return ("CamelRoutesNode-" + this.camelContextNode.getManagementName() + "-" + this.toString() + "-" + this.getConnection().getProvider().getName(this.getConnection())).hashCode();
        }
        return super.hashCode();
    }
}

