/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.graphiti.ui.editor.IDiagramEditorInput;
import org.eclipse.graphiti.ui.internal.parts.ContainerShapeEditPart;
import org.eclipse.graphiti.ui.internal.util.gef.ScalableRootEditPartAnimated;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.fusesource.ide.camel.editor.CamelEditor;
import org.fusesource.ide.camel.editor.PaletteRefresherOnOpenPartListener;
import org.fusesource.ide.camel.editor.behaviours.CamelDiagramBehaviour;
import org.fusesource.ide.camel.editor.commands.DiagramOperations;
import org.fusesource.ide.camel.editor.commands.ImportCamelContextElementsCommand;
import org.fusesource.ide.camel.editor.internal.CamelDesignEditorFlyoutPaletteComposite;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.editor.outline.CamelModelOutlinePage;
import org.fusesource.ide.camel.editor.provider.CamelEditorContextMenuProvider;
import org.fusesource.ide.camel.editor.utils.DiagramUtils;
import org.fusesource.ide.camel.editor.utils.INodeViewer;
import org.fusesource.ide.camel.editor.utils.NodeUtils;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelContextElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.camel.model.service.core.model.ICamelModelListener;
import org.fusesource.ide.foundation.core.util.Objects;
import org.fusesource.ide.foundation.ui.io.CamelXMLEditorInput;
import org.fusesource.ide.foundation.ui.util.Selections;
import org.fusesource.ide.launcher.debug.model.CamelStackFrame;
import org.fusesource.ide.launcher.debug.model.CamelThread;
import org.fusesource.ide.launcher.debug.util.CamelDebugRegistry;
import org.fusesource.ide.launcher.debug.util.CamelDebugRegistryEntry;
import org.fusesource.ide.preferences.PreferenceManager;

public class CamelDesignEditor
extends DiagramEditor
implements ISelectionListener,
INodeViewer,
ICamelModelListener,
IDebugEventSetListener,
IBreakpointsListener {
    private CamelEditor parent;
    private IProject workspaceProject;
    private CamelDiagramBehaviour camelDiagramBehaviour;
    private CamelDesignEditorFlyoutPaletteComposite paletteComposite;
    private CamelFile model;
    private AbstractCamelModelElement selectedContainer;
    private AbstractCamelModelElement highlightedNodeInDebugger;
    private AbstractEditPart selectedEditPart;
    private AbstractEditPart lastSelectedEditPart;
    private KeyHandler keyHandler;
    private CamelModelOutlinePage outlinePage;
    private PaletteRefresherOnOpenPartListener paletteRefresher;

    public CamelDesignEditor(CamelEditor parent) {
        this.parent = parent;
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            ISelectionService sel = activeWorkbenchWindow.getSelectionService();
            if (sel != null) {
                sel.addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
            }
            this.paletteRefresher = new PaletteRefresherOnOpenPartListener(this);
            activeWorkbenchWindow.getActivePage().addPartListener((IPartListener2)this.paletteRefresher);
        }
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
    }

    public void doSave(IProgressMonitor monitor) {
        this.parent.doSave(monitor);
    }

    public void doSaveAs() {
        this.parent.doSaveAs();
    }

    protected DiagramBehavior createDiagramBehavior() {
        this.camelDiagramBehaviour = new CamelDiagramBehaviour((IDiagramContainerUI)this);
        return this.camelDiagramBehaviour;
    }

    public CamelDiagramBehaviour getDiagramBehavior() {
        return this.camelDiagramBehaviour;
    }

    public void dispose() {
        IWorkbenchWindow activeWorkbenchWindow;
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
        if (this.getModel() != null) {
            this.getModel().removeModelListener((ICamelModelListener)this);
        }
        if (this.paletteRefresher != null && (activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            activeWorkbenchWindow.getActivePage().removePartListener((IPartListener2)this.paletteRefresher);
        }
        super.dispose();
    }

    public void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        CamelEditorContextMenuProvider provider = new CamelEditorContextMenuProvider(this, this, (EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)provider);
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.getDiagramBehavior().getEditorInitializationError() == null) {
            try {
                for (CamelDebugRegistryEntry entry : CamelDebugRegistry.getInstance().getEntries().values()) {
                    IResource f = this.model.getResource();
                    if (!f.getFullPath().toFile().getPath().equals(this.asFileEditorInput(input).getFile().getFullPath().toFile().getPath())) continue;
                    String endpointId = null;
                    if (entry == null || entry.getDebugTarget() == null || entry.getDebugTarget().getDebugger() == null) continue;
                    Set ids = entry.getDebugTarget().getDebugger().getSuspendedBreakpointNodeIds();
                    if (ids != null && !ids.isEmpty()) {
                        endpointId = (String)ids.iterator().next();
                    }
                    this.highlightBreakpointNodeWithID(endpointId);
                }
            }
            catch (Exception ex) {
                CamelEditorUIActivator.pluginLog().logError((Throwable)ex);
            }
            this.setupGridVisibilityAsync();
            this.outlinePage = new CamelModelOutlinePage(this);
        }
    }

    public void setFocus() {
        super.setFocus();
        if (this.getModel() != null) {
            DiagramOperations.updateDiagram(this);
        }
    }

    public boolean isDirty() {
        return this.parent.isDirty();
    }

    protected FlyoutPaletteComposite createPaletteComposite(Composite parent) {
        this.paletteComposite = new CamelDesignEditorFlyoutPaletteComposite(parent, 0, this.getSite().getPage(), this.getPaletteViewerProvider(), this.getPalettePreferences());
        this.paletteComposite.getFilter().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CamelDesignEditor.this.getDiagramBehavior().refreshPalette();
            }
        });
        return this.paletteComposite;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.getSite().getPage().getActiveEditor() == this.parent && this.parent.getActiveEditor() == this) {
            this.updateActions(this.getSelectionActions());
            if (selection instanceof StructuredSelection) {
                StructuredSelection structuredSelection = (StructuredSelection)selection;
                Object firstElement = structuredSelection.getFirstElement();
                if (firstElement instanceof AbstractCamelModelElement) {
                    AbstractCamelModelElement node = (AbstractCamelModelElement)firstElement;
                    if (node != null && !(node instanceof CamelContextElement)) {
                        this.setSelectedNode(node);
                    }
                } else if (firstElement instanceof ContainerShapeEditPart) {
                    AbstractCamelModelElement node = NodeUtils.toCamelElement(firstElement);
                    if (node != null) {
                        this.outlinePage.setOutlineSelection(node);
                    }
                } else if (firstElement instanceof CamelStackFrame) {
                    CamelStackFrame stackFrame = (CamelStackFrame)firstElement;
                    this.highlightBreakpointNodeWithID(stackFrame.getEndpointId());
                } else if (firstElement instanceof CamelThread) {
                    CamelThread t = (CamelThread)firstElement;
                    try {
                        CamelStackFrame stackFrame = (CamelStackFrame)t.getTopStackFrame();
                        if (stackFrame != null) {
                            this.highlightBreakpointNodeWithID(stackFrame.getEndpointId());
                        }
                    }
                    catch (DebugException e) {
                        CamelEditorUIActivator.pluginLog().logError((Throwable)e);
                    }
                }
            }
        }
    }

    public KeyHandler getKeyHandler() {
        return this.keyHandler;
    }

    public void initializeDiagram(Diagram diagram) {
        IDiagramTypeProvider diagramTypeProvider = this.getDiagramTypeProvider();
        if (diagramTypeProvider == null) {
            return;
        }
        if (diagramTypeProvider.getDiagram() != diagram) {
            diagramTypeProvider.resourceReloaded(diagram);
        }
        diagramTypeProvider.init(diagram, (IDiagramBehavior)this.getDiagramBehavior());
        this.getDiagramBehavior().getRefreshBehavior().initRefresh();
    }

    public CamelFile getModel() {
        return this.model;
    }

    public void setModel(CamelFile model) {
        if (this.model != model) {
            this.model = model;
            if (model != null && model.getCamelFile() != null) {
                model.getCamelFile().addModelListener((ICamelModelListener)this);
                model.getCamelFile().addModelListener((ICamelModelListener)this.getParent().getGlobalConfigEditor());
                this.selectedContainer = model.getCamelContext();
            }
        }
    }

    public IProject getWorkspaceProject() {
        return this.workspaceProject;
    }

    public void setWorkspaceProject(IProject workspaceProject) {
        this.workspaceProject = workspaceProject;
    }

    public String getPaletteFilter() {
        if (this.paletteComposite != null && !this.paletteComposite.getFilter().isDisposed()) {
            return this.paletteComposite.getFilter().getText();
        }
        return null;
    }

    public IFileEditorInput asFileEditorInput(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            return (IFileEditorInput)input;
        }
        if (input instanceof CamelXMLEditorInput) {
            return new FileEditorInput((IFile)input.getAdapter(IFile.class));
        }
        if (input instanceof IDiagramEditorInput) {
            URI uri = ((IDiagramEditorInput)input).getUri();
            if (uri.isPlatformResource()) {
                return new FileEditorInput(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true))));
            }
            FileEditorInput ei = new FileEditorInput(ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(uri.toFileString())));
            return ei;
        }
        return null;
    }

    public IFeatureProvider getFeatureProvider() {
        if (this.getDiagramTypeProvider() != null) {
            return this.getDiagramTypeProvider().getFeatureProvider();
        }
        return null;
    }

    public Object getAdapter(Class type) {
        if (type == GraphicalViewer.class || type == GraphicalEditorWithFlyoutPalette.class || type == EditPartViewer.class) {
            return this.getGraphicalViewer();
        }
        if (type == IContentOutlinePage.class) {
            return this.outlinePage;
        }
        if (type == CommandStack.class) {
            return this.getCommandStack();
        }
        if (type == EditDomain.class) {
            return this.getEditDomain();
        }
        if (type == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (type == ZoomManager.class) {
            GraphicalViewer graphicalViewer = this.getGraphicalViewer();
            if (graphicalViewer == null) {
                return null;
            }
            RootEditPart root = graphicalViewer.getRootEditPart();
            if (root instanceof ScalableRootEditPartAnimated) {
                ScalableRootEditPartAnimated scalableRoot = (ScalableRootEditPartAnimated)root;
                return scalableRoot.getZoomManager();
            }
            if (root instanceof ScalableRootEditPart) {
                return ((ScalableRootEditPart)root).getZoomManager();
            }
            return null;
        }
        return super.getAdapter(type);
    }

    public CamelEditor getParent() {
        return this.parent;
    }

    public AbstractCamelModelElement getSelectedContainer() {
        return this.selectedContainer;
    }

    public void setSelectedContainer(AbstractCamelModelElement route) {
        this.selectedContainer = route;
        this.switchContainer();
        if (this.selectedContainer == null) {
            this.selectedContainer = this.getModel().getCamelContext();
        }
    }

    protected void switchContainer() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                CamelDesignEditor.this.parent.stopDirtyListener();
                CamelDesignEditor.this.getEditorSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection());
                AbstractCamelModelElement container = CamelDesignEditor.this.getSelectedContainer() != null ? CamelDesignEditor.this.getSelectedContainer() : CamelDesignEditor.this.getModel();
                ImportCamelContextElementsCommand importCommand = new ImportCamelContextElementsCommand(CamelDesignEditor.this, CamelDesignEditor.this.getEditingDomain(), container, null);
                CamelDesignEditor.this.getEditingDomain().getCommandStack().execute((Command)importCommand);
                CamelDesignEditor.this.initializeDiagram(importCommand.getDiagram());
                CamelDesignEditor.this.update();
                CamelDesignEditor.this.parent.updateSelectedContainer(CamelDesignEditor.this.getSelectedContainer() != null ? CamelDesignEditor.this.getSelectedContainer().getId() : CamelDesignEditor.this.getModel().getCamelContext().getId());
                CamelDesignEditor.this.refreshDiagramContents(importCommand.getDiagram());
                CamelDesignEditor.this.outlinePage.changeInput(container);
            }
        };
        Display.getDefault().asyncExec(r);
    }

    public void refreshDiagramContents(Diagram diagram) {
        if (this.getDiagramTypeProvider() != null) {
            this.getDiagramTypeProvider().init(diagram != null ? diagram : this.getDiagramTypeProvider().getDiagram(), (IDiagramBehavior)this.getDiagramBehavior());
        }
        this.setPictogramElementsForSelection(null);
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        if (graphicalViewer == null) {
            return;
        }
        graphicalViewer.setContents((Object)this.getDiagramTypeProvider().getDiagram());
        this.getDiagramBehavior().getRefreshBehavior().initRefresh();
        this.getDiagramBehavior().refreshContent();
        this.refreshOutlineView();
    }

    public void modelChanged() {
        this.parent.setDirtyFlag(true);
        if (this.getParent().getActivePage() != 0) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DiagramOperations.updateSelectedNode(CamelDesignEditor.this);
                CamelDesignEditor.this.getDiagramTypeProvider().getDiagramBehavior().refresh();
                if (CamelDesignEditor.this.selectedEditPart != null) {
                    CamelDesignEditor.this.selectedEditPart.refresh();
                } else if (CamelDesignEditor.this.lastSelectedEditPart != null) {
                    CamelDesignEditor.this.lastSelectedEditPart.refresh();
                }
            }
        });
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CamelDesignEditor.this.refreshDiagramContents(null);
            }
        });
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CamelDesignEditor.this.refreshDiagramContents(null);
            }
        });
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CamelDesignEditor.this.refreshDiagramContents(null);
            }
        });
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent ev = debugEventArray[n2];
            if (ev.getSource() instanceof CamelThread || ev.getSource() instanceof CamelStackFrame) {
                if (ev.getSource() instanceof CamelThread && (ev.getKind() == 8 || ev.getKind() == 1)) {
                    this.resetHighlightBreakpointNode();
                } else if (ev.getSource() instanceof CamelThread) {
                    CamelThread thread = (CamelThread)ev.getSource();
                    if (ev.getKind() == 2 && ev.getDetail() == 16) {
                        try {
                            CamelStackFrame stackFrame = (CamelStackFrame)thread.getTopStackFrame();
                            if (stackFrame != null) {
                                this.highlightBreakpointNodeWithID(stackFrame.getEndpointId());
                            }
                        }
                        catch (DebugException ex) {
                            CamelEditorUIActivator.pluginLog().logError((Throwable)ex);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public synchronized AbstractCamelModelElement getHighlightedNodeInDebugger() {
        return this.highlightedNodeInDebugger;
    }

    private synchronized void highlightBreakpointNodeWithID(String endpointNodeId) {
        AbstractCamelModelElement node = this.getModel().findNode(endpointNodeId);
        if (node == null) {
            return;
        }
        if (this.highlightedNodeInDebugger != null && node.getId() != null && node.getId().equals(this.highlightedNodeInDebugger.getId())) {
            return;
        }
        this.resetHighlightBreakpointNode();
        this.setDebugHighLight(node, true);
        this.highlightedNodeInDebugger = node;
    }

    private synchronized void resetHighlightBreakpointNode() {
        this.setDebugHighLight(this.highlightedNodeInDebugger, false);
        this.highlightedNodeInDebugger = null;
    }

    private synchronized void setDebugHighLight(AbstractCamelModelElement bo, boolean highlight) {
        if (bo == null) {
            return;
        }
        DiagramOperations.highlightNode(this, bo, highlight);
    }

    protected RootEditPart getRootEditPart() {
        return this.getGraphicalViewer().getRootEditPart();
    }

    @Override
    public AbstractCamelModelElement getSelectedNode() {
        return NodeUtils.getSelectedNode(Selections.getSelection((IWorkbenchSite)this.getEditorSite()));
    }

    public static EditPart findEditPart(AbstractCamelModelElement node, EditPart part) {
        EditPart nodeEditPart;
        AbstractCamelModelElement modelNode;
        RootEditPart root;
        EditPart contents;
        if (part instanceof RootEditPart && (contents = (root = (RootEditPart)part).getContents()) != null) {
            return CamelDesignEditor.findEditPart(node, contents);
        }
        if (part instanceof EditPart && (Objects.equal((Object)node, (Object)(modelNode = NodeUtils.toCamelElement(nodeEditPart = part))) || node.getId().equals(modelNode.getId()))) {
            return nodeEditPart;
        }
        List children = part.getChildren();
        for (EditPart childPart : children) {
            EditPart answer = CamelDesignEditor.findEditPart(node, childPart);
            if (answer == null) continue;
            return answer;
        }
        return null;
    }

    @Override
    public void setSelectedNode(AbstractCamelModelElement newSelection) {
        if (newSelection != null) {
            Object editPart = this.getGraphicalViewer().getEditPartRegistry().get(this.getFeatureProvider().getPictogramElementForBusinessObject((Object)newSelection));
            if (editPart != null) {
                this.getEditorSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(editPart));
                this.getGraphicalViewer().reveal((EditPart)editPart);
            } else {
                CamelEditorUIActivator.pluginLog().logError("Could not select editPart for selection: " + newSelection);
            }
        }
    }

    public void autoLayoutRoute() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                DiagramOperations.layoutDiagram(CamelDesignEditor.this);
            }
        });
    }

    public void setupGridVisibilityAsync() {
        DiagramOperations.updateGridColor(this);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CamelDesignEditor.this.setupGridVisibility();
            }
        });
    }

    public void refreshOutlineView() {
        if (this.outlinePage != null) {
            this.outlinePage.modelChanged();
        }
    }

    private void setupGridVisibility() {
        boolean gridVisible = PreferenceManager.getInstance().loadPreferenceAsBoolean("diagramGridVisibilityPreference");
        DiagramUtils.setGridVisible(gridVisible, this);
        this.getDiagramBehavior().refresh();
    }

    public void update() {
        Diagram diagram;
        DiagramOperations.updateDiagram(this);
        this.getDiagramBehavior().refresh();
        if (this.getModel() != null && (diagram = this.getDiagramTypeProvider().getDiagram()) != null) {
            this.selectPictogramElements(new PictogramElement[]{diagram.getContainer()});
        }
    }

    public void clearCache() {
        this.getDiagramTypeProvider().getDiagram().eResource().eAdapters().clear();
        this.getEditingDomain().getResourceSet().getResources().remove((Object)this.getDiagramTypeProvider().getDiagram().eResource());
    }
}

